/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.william278.desertwell.util.UpdateChecker;
import dev.xf3d3.ultimateteams.libraries.william278.desertwell.util.Version;
import java.util.logging.Level;

public class UpdateCheck {
    private final UltimateTeams plugin;

    public UpdateCheck(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    private Version getVersion() {
        return Version.fromString(this.plugin.getDescription().getVersion());
    }

    @NotNull
    private UpdateChecker getUpdateChecker() {
        return UpdateChecker.builder().currentVersion(this.getVersion()).endpoint(UpdateChecker.Endpoint.MODRINTH).resource("O5OQXCl8").build();
    }

    public void checkForUpdates() {
        if (this.plugin.getSettings().doCheckForUpdates()) {
            this.getUpdateChecker().check().thenAccept(checked -> {
                if (!checked.isUpToDate()) {
                    this.plugin.log(Level.WARNING, "A new version of UltimateTeams is available: v" + String.valueOf(checked.getLatestVersion()) + " (running v" + String.valueOf(this.getVersion()) + ")", new Throwable[0]);
                }
            });
        }
    }
}

