/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl;

import com.google.auto.service.AutoService;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.kyori.adventure.platform.fabric.CollectPointersCallback;
import net.kyori.adventure.platform.fabric.PlayerLocales;
import net.kyori.adventure.platform.fabric.impl.ClientboundArgumentTypeMappingsPacket;
import net.kyori.adventure.platform.fabric.impl.ServerArgumentType;
import net.kyori.adventure.platform.fabric.impl.ServerArgumentTypes;
import net.kyori.adventure.platform.fabric.impl.ServerboundRegisteredArgumentTypesPacket;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerBridge;
import net.kyori.adventure.platform.modcommon.ComponentArgumentType;
import net.kyori.adventure.platform.modcommon.KeyArgumentType;
import net.kyori.adventure.platform.modcommon.impl.AdventureCommon;
import net.kyori.adventure.platform.modcommon.impl.ClickCallbackRegistry;
import net.kyori.adventure.platform.modcommon.impl.ComponentArgumentTypeSerializer;
import net.kyori.adventure.platform.modcommon.impl.PlatformHooks;
import net.kyori.adventure.platform.modcommon.impl.SidedProxy;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.pointer.Pointers;
import net.minecraft.class_2178;
import net.minecraft.class_2232;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class AdventureFabricCommon
implements ModInitializer {
    private static final Logger LOGGER;
    public static final SidedProxy SIDE_PROXY;
    public static final String MOD_FAPI_NETWORKING = "fabric-networking-api-v1";

    private static SidedProxy chooseSidedProxy() {
        EnvType environment = FabricLoader.getInstance().getEnvironmentType();
        List sidedProxyContainers = FabricLoader.getInstance().getEntrypointContainers("adventure-internal:sidedproxy/" + environment.name().toLowerCase(Locale.ROOT), SidedProxy.class);
        return switch (sidedProxyContainers.size()) {
            case 0 -> throw new IllegalStateException("No sided proxies were available for adventure-platform-fabric in environment " + String.valueOf(environment));
            case 1 -> {
                EntrypointContainer proxy = (EntrypointContainer)sidedProxyContainers.getFirst();
                LOGGER.debug("Selected sided proxy {} from {}", proxy.getEntrypoint(), (Object)proxy.getProvider().getMetadata().getId());
                yield (SidedProxy)proxy.getEntrypoint();
            }
            default -> {
                EntrypointContainer proxy = (EntrypointContainer)sidedProxyContainers.getFirst();
                LOGGER.warn("Multiple applicable proxies were applicable, choosing first available: {} from {}", proxy.getEntrypoint(), (Object)proxy.getProvider().getMetadata().getId());
                yield (SidedProxy)proxy.getEntrypoint();
            }
        };
    }

    public void onInitialize() {
        this.setupCustomArgumentTypes();
        CommandRegistrationCallback.EVENT.register((dispatcher, registries, env) -> ClickCallbackRegistry.INSTANCE.registerToDispatcher(dispatcher));
        AdventureCommon.scheduleClickCallbackCleanup();
        if (Boolean.getBoolean("adventure.testMode") && FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                MixinEnvironment.getCurrentEnvironment().audit();
                server.execute(() -> {
                    try {
                        Files.writeString(Path.of("adventure-test-success.out", new String[0]), (CharSequence)"true", new OpenOption[0]);
                    }
                    catch (IOException ex) {
                        System.exit(1);
                    }
                    server.method_3747(false);
                });
            });
        }
    }

    private void setupCustomArgumentTypes() {
        if (FabricLoader.getInstance().isModLoaded(MOD_FAPI_NETWORKING)) {
            ClientboundArgumentTypeMappingsPacket.register();
            ServerboundRegisteredArgumentTypesPacket.register();
        }
        ServerArgumentTypes.register(new ServerArgumentType<ComponentArgumentType>(AdventureCommon.res((String)"component"), ComponentArgumentType.class, (class_2314<ComponentArgumentType, class_2314.class_7217<ComponentArgumentType>>)ComponentArgumentTypeSerializer.INSTANCE, (BiFunction<ComponentArgumentType, class_7157, ArgumentType<?>>)((BiFunction<ComponentArgumentType, class_7157, ArgumentType>)(arg, ctx) -> switch (arg.format()) {
            default -> throw new MatchException(null, null);
            case ComponentArgumentType.Format.JSON -> class_2178.method_9281((class_7157)ctx);
            case ComponentArgumentType.Format.MINIMESSAGE -> StringArgumentType.greedyString();
        }), null));
        ServerArgumentTypes.register(new ServerArgumentType<KeyArgumentType>(AdventureCommon.res((String)"key"), KeyArgumentType.class, (class_2314<KeyArgumentType, class_2314.class_7217<KeyArgumentType>>)class_2319.method_41999(KeyArgumentType::key), (BiFunction<KeyArgumentType, class_7157, ArgumentType<?>>)((BiFunction<KeyArgumentType, class_7157, ArgumentType>)(arg, ctx) -> class_2232.method_9441()), null));
    }

    static {
        SidedProxy sidedProxy;
        LOGGER = LogUtils.getLogger();
        SIDE_PROXY = sidedProxy = AdventureFabricCommon.chooseSidedProxy();
    }

    @AutoService(value={PlatformHooks.class})
    public static final class FabricHooks
    implements PlatformHooks {
        public SidedProxy sidedProxy() {
            return SIDE_PROXY;
        }

        public void updateTabList(class_3222 player, @Nullable class_2561 header, @Nullable class_2561 footer) {
            ((ServerPlayerBridge)player).bridge$updateTabList(header, footer);
        }

        public void collectPointers(Pointered pointered, Pointers.Builder builder) {
            super.collectPointers(pointered, builder);
            ((CollectPointersCallback)CollectPointersCallback.EVENT.invoker()).registerPointers(pointered, builder);
        }

        public void onLocaleChange(class_3222 player, Locale newLocale) {
            super.onLocaleChange(player, newLocale);
            ((PlayerLocales.Changed)PlayerLocales.CHANGED_EVENT.invoker()).onLocaleChanged(player, newLocale);
        }
    }
}

