/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.compat.permissions;

import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.platform.fabric.CollectPointersCallback;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minecraft.class_1297;
import net.minecraft.class_2172;

public class PermissionsApiIntegration
implements ModInitializer {
    private static final ComponentLogger LOGGER = ComponentLogger.logger();
    private static final String PERMISSIONS_API_MOD_NAME = "fabric-permissions-api-v0";

    public void onInitialize() {
        if (FabricLoader.getInstance().isModLoaded(PERMISSIONS_API_MOD_NAME)) {
            this.registerPermissionHook();
            LOGGER.debug("Registered fabric-permissions-api hook");
        } else {
            LOGGER.debug("fabric-permissions-api not detected, the PermissionChecker pointer will not be present");
        }
    }

    private void registerPermissionHook() {
        CollectPointersCallback.EVENT.register((pointered, consumer) -> {
            if (pointered instanceof class_1297) {
                class_1297 e = (class_1297)pointered;
                consumer.withStatic(PermissionChecker.POINTER, perm -> PermissionsApiIntegration.adaptTristate(Permissions.getPermissionValue((class_1297)e, (String)perm)));
            } else if (pointered instanceof class_2172) {
                class_2172 sourceStack = (class_2172)pointered;
                consumer.withStatic(PermissionChecker.POINTER, perm -> PermissionsApiIntegration.adaptTristate(Permissions.getPermissionValue((class_2172)sourceStack, (String)perm)));
            }
        });
    }

    private static net.kyori.adventure.util.TriState adaptTristate(TriState fabricState) {
        return switch (fabricState) {
            default -> throw new MatchException(null, null);
            case TriState.FALSE -> net.kyori.adventure.util.TriState.FALSE;
            case TriState.DEFAULT -> net.kyori.adventure.util.TriState.NOT_SET;
            case TriState.TRUE -> net.kyori.adventure.util.TriState.TRUE;
        };
    }
}

