/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.neoforge.impl;

import com.google.auto.service.AutoService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.platform.modcommon.ComponentArgumentType;
import net.kyori.adventure.platform.modcommon.KeyArgumentType;
import net.kyori.adventure.platform.modcommon.impl.AdventureCommon;
import net.kyori.adventure.platform.modcommon.impl.ClickCallbackRegistry;
import net.kyori.adventure.platform.modcommon.impl.ComponentArgumentTypeSerializer;
import net.kyori.adventure.platform.modcommon.impl.LocaleHolderBridge;
import net.kyori.adventure.platform.modcommon.impl.PlatformHooks;
import net.kyori.adventure.platform.modcommon.impl.SidedProxy;
import net.kyori.adventure.platform.modcommon.impl.client.ClientProxy;
import net.kyori.adventure.platform.modcommon.impl.server.DedicatedServerProxy;
import net.kyori.adventure.platform.neoforge.CollectPointersEvent;
import net.kyori.adventure.platform.neoforge.impl.services.ANSIComponentSerializerProviderImpl;
import net.kyori.adventure.platform.neoforge.impl.services.ClickCallbackProviderImpl;
import net.kyori.adventure.platform.neoforge.impl.services.ComponentLoggerProviderImpl;
import net.kyori.adventure.platform.neoforge.impl.services.DataComponentValueConverterProvider;
import net.kyori.adventure.platform.neoforge.impl.services.GsonComponentSerializerProviderImpl;
import net.kyori.adventure.platform.neoforge.impl.services.PlainTextComponentSerializerProviderImpl;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.util.TriState;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.Nullable;

@Mod(value="adventure_platform_neoforge")
public final class AdventureNeoforgeCommon {
    public static SidedProxy SIDE_PROXY;
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;

    public static void registerArgumentTypes() {
        COMMAND_ARGUMENT_TYPES.register("component", () -> (ComponentArgumentTypeSerializer)ArgumentTypeInfos.registerByClass(ComponentArgumentType.class, (ArgumentTypeInfo)ComponentArgumentTypeSerializer.INSTANCE));
        COMMAND_ARGUMENT_TYPES.register("key", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(KeyArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(KeyArgumentType::key)));
    }

    public AdventureNeoforgeCommon(IEventBus bus) {
        COMMAND_ARGUMENT_TYPES.register(bus);
        NeoForge.EVENT_BUS.addListener(e -> {
            if (!Objects.equals(e.getOldInformation().language(), e.getUpdatedInformation().language())) {
                AdventureCommon.HOOKS.onLocaleChange(e.getEntity(), LocaleHolderBridge.toLocale((String)e.getUpdatedInformation().language()));
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> ClickCallbackRegistry.INSTANCE.registerToDispatcher(e.getDispatcher()));
        AdventureCommon.scheduleClickCallbackCleanup();
    }

    static {
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"adventure");
        SIDE_PROXY = FMLLoader.getDist() == Dist.DEDICATED_SERVER ? new DedicatedServerProxy() : new ClientProxy();
        ANSIComponentSerializerProviderImpl.DELEGATE = new net.kyori.adventure.platform.modcommon.impl.service.ANSIComponentSerializerProviderImpl();
        ClickCallbackProviderImpl.DELEGATE = new net.kyori.adventure.platform.modcommon.impl.service.ClickCallbackProviderImpl();
        ComponentLoggerProviderImpl.DELEGATE = new net.kyori.adventure.platform.modcommon.impl.service.ComponentLoggerProviderImpl();
        DataComponentValueConverterProvider.DELEGATE = new net.kyori.adventure.platform.modcommon.impl.service.DataComponentValueConverterProvider();
        GsonComponentSerializerProviderImpl.DELEGATE = new net.kyori.adventure.platform.modcommon.impl.service.GsonComponentSerializerProviderImpl();
        PlainTextComponentSerializerProviderImpl.DELEGATE = new net.kyori.adventure.platform.modcommon.impl.service.PlainTextComponentSerializerProviderImpl();
    }

    @AutoService(value={PlatformHooks.class})
    public static final class ForgeHooks
    implements PlatformHooks {
        private static final Cache<String, PermissionNode<Boolean>> PERMISSION_NODE_CACHE = CacheBuilder.newBuilder().maximumSize(100L).build();
        private static final PermissionNode<Boolean> NULL = new PermissionNode("adventure", "null", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> true, new PermissionDynamicContextKey[0]);

        public SidedProxy sidedProxy() {
            return SIDE_PROXY;
        }

        public void updateTabList(ServerPlayer player, @Nullable Component header, @Nullable Component footer) {
            player.setTabListHeaderFooter(header == null ? player.getTabListHeader() : header, footer == null ? player.getTabListFooter() : footer);
        }

        public void collectPointers(Pointered pointered, Pointers.Builder builder) {
            super.collectPointers(pointered, builder);
            if (pointered instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)pointered;
                builder.withStatic(PermissionChecker.POINTER, perm -> this.hasPermission(player, perm));
            }
            NeoForge.EVENT_BUS.post((Event)new CollectPointersEvent(pointered, builder));
        }

        private TriState hasPermission(ServerPlayer player, String permission) {
            PermissionNode node;
            try {
                node = (PermissionNode)PERMISSION_NODE_CACHE.get((Object)permission, () -> PermissionAPI.getRegisteredNodes().stream().filter(n -> n.getNodeName().equals(permission) && n.getType() == PermissionTypes.BOOLEAN).findFirst().orElse(NULL));
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (node == NULL) {
                return TriState.NOT_SET;
            }
            return TriState.byBoolean((Boolean)((Boolean)PermissionAPI.getPermission((ServerPlayer)player, (PermissionNode)node, (PermissionDynamicContext[])new PermissionDynamicContext[0])));
        }
    }
}

