/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.platform.fabric.impl.ClientboundArgumentTypeMappingsPacket;
import net.kyori.adventure.platform.fabric.impl.ServerArgumentTypes;
import net.kyori.adventure.platform.fabric.impl.ServerboundRegisteredArgumentTypesPacket;

@Environment(value=EnvType.CLIENT)
public final class AdventureFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.setupCustomArgumentTypes();
    }

    private void setupCustomArgumentTypes() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            C2SPlayChannelEvents.REGISTER.register((handler, sender, client, channels) -> {
                if (channels.contains(ServerboundRegisteredArgumentTypesPacket.TYPE.comp_2242())) {
                    client.execute(() -> {
                        if (ClientPlayNetworking.canSend(ServerboundRegisteredArgumentTypesPacket.TYPE)) {
                            ServerboundRegisteredArgumentTypesPacket.of(ServerArgumentTypes.ids()).sendTo(sender);
                        }
                    });
                }
            });
            ClientPlayNetworking.registerGlobalReceiver(ClientboundArgumentTypeMappingsPacket.TYPE, (pkt, ctx) -> ctx.client().execute(() -> ServerArgumentTypes.receiveMappings(pkt)));
        }
    }
}

