/*
 * Decompiled with CFR 0.152.
 */
package loggamja.mcsync;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import loggamja.mcsync.MCSyncConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_310;

public class MCRiderRotate
implements ModInitializer {
    public static String currentSaddleType = "none";
    public static List<Float> playerYawBuffer = new ArrayList<Float>();
    static MCSyncConfig cfg;
    static class_310 client;

    public void onInitialize() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.onClientTickEnd());
        MCSyncConfig.INSTANCE.load();
        cfg = MCSyncConfig.INSTANCE;
        playerYawBuffer.add(Float.valueOf(0.0f));
    }

    public static boolean isPlayingInGame() {
        class_310 client = class_310.method_1551();
        return client.field_1687 != null && client.field_1724 != null && !client.method_1493() && client.method_47599() >= 40;
    }

    void onClientTickEnd() {
        class_1297 kartMobil;
        if (!MCRiderRotate.isPlayingInGame()) {
            return;
        }
        class_1297 vehicle = Objects.requireNonNull(MCRiderRotate.client.field_1724).method_5854();
        this.updateCurrentSaddleType(vehicle);
        if (!currentSaddleType.equals("none") && MCRiderRotate.cfg.MCRiderRotationOption > 0 && !this.hasCertainName(kartMobil = MCRiderRotate.client.field_1724.method_5668(), "mcrider-stop")) {
            this.simulateKartRotation(kartMobil);
        }
    }

    void updateCurrentSaddleType(class_1297 vehicle) {
        currentSaddleType = this.hasCertainName(vehicle, "mcrider-saddle-common") ? "common" : (this.hasCertainName(vehicle, "mcrider-saddle-1.0") ? "1.0" : (this.hasCertainName(vehicle, "mcrider-saddle-boat") ? "boat" : "none"));
    }

    boolean hasCertainName(class_1297 entity, String saddleName) {
        if (entity != null && entity.method_5797() != null) {
            return entity.method_5797().toString().equals("literal{" + saddleName + "}");
        }
        return false;
    }

    void simulateKartRotation(class_1297 kartMobil) {
        if (kartMobil == MCRiderRotate.client.field_1724) {
            return;
        }
        List passengers = kartMobil.method_5685();
        block0: for (class_1297 i : passengers) {
            if (!this.hasCertainName(i, "mcrider-direction")) continue;
            for (class_1297 j : passengers) {
                if (!this.hasCertainName(j, "mcrider-modelsaddle")) continue;
                float angleToRotate = this.calculateRotation(i.method_36454());
                this.rotateKartModel(j, angleToRotate);
                break block0;
            }
        }
    }

    float calculateRotation(float directionYaw) {
        Float playerYaw = playerYawBuffer.getFirst();
        float deltaAngle = this.normalizeAngle(playerYaw.floatValue() - directionYaw);
        float overShootAngle = this.getOverShootAngle(deltaAngle);
        if (currentSaddleType.equals("boat")) {
            return this.normalizeAngle(playerYaw.floatValue());
        }
        return this.normalizeAngle(playerYaw.floatValue() + overShootAngle);
    }

    void rotateKartModel(class_1297 entity, float angleToRotate) {
        List models = entity.method_5685();
        for (class_1297 j : models) {
            j.method_36456(angleToRotate);
        }
    }

    float getOverShootAngle(float deltaAngle) {
        float overShootAngle = deltaAngle;
        if (currentSaddleType.equals("1.0")) {
            if (deltaAngle <= -55.0f) {
                overShootAngle = -110.0f - deltaAngle;
            }
            if (55.0f <= deltaAngle) {
                overShootAngle = 110.0f - deltaAngle;
            }
        } else {
            if (-110.0f <= deltaAngle && deltaAngle <= -55.0f) {
                overShootAngle = -110.0f - deltaAngle;
            }
            if (55.0f <= deltaAngle && deltaAngle <= 110.0f) {
                overShootAngle = 110.0f - deltaAngle;
            }
            if (deltaAngle < -110.0f || deltaAngle > 110.0f) {
                overShootAngle = 0.0f;
            }
        }
        return overShootAngle / 2.0f;
    }

    float normalizeAngle(float angle) {
        if (angle > 0.0f) {
            return (angle + 180.0f) % 360.0f - 180.0f;
        }
        return -((-angle + 180.0f) % 360.0f - 180.0f);
    }

    public static void onFrameRender() {
        float playerYaw = Objects.requireNonNull(MCRiderRotate.client.field_1724).method_36454();
        MCRiderRotate.addToPlayerYawBuffer(Float.valueOf(playerYaw));
    }

    static void addToPlayerYawBuffer(Float playerYaw) {
        playerYawBuffer.add(playerYaw);
        long delay = MCRiderRotate.getNearestFrame(25L);
        if (MCRiderRotate.cfg.MCRiderRotationOption == 2) {
            delay = 1L;
        }
        while ((long)playerYawBuffer.size() > delay) {
            playerYawBuffer.removeFirst();
        }
    }

    static long getNearestFrame(long criteria) {
        float fps = client.method_47599();
        float frameMs = 1000.0f / fps;
        long k = Math.round((float)criteria / frameMs);
        return Math.max(1L, k);
    }

    static {
        client = class_310.method_1551();
    }
}

