/*
 * Decompiled with CFR 0.152.
 */
package loggamja.mcsync;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class MCSyncConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "mcsync-config.json");
    public int MCRiderRotationOption = 1;
    public boolean MCRiderPacketAcceleration = true;
    public static final MCSyncConfig INSTANCE = new MCSyncConfig();

    public void load() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            MCSyncConfig loaded = (MCSyncConfig)GSON.fromJson((Reader)reader, MCSyncConfig.class);
            if (loaded != null) {
                this.MCRiderRotationOption = loaded.MCRiderRotationOption;
                this.MCRiderPacketAcceleration = loaded.MCRiderPacketAcceleration;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

