/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.nowtime.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Path.of("config", "nowtime.json");
    public static ModConfig config;

    public static void loadConfig() {
        try {
            if (!CONFIG_PATH.toFile().exists()) {
                ConfigManager.createDefaultConfig();
            }
            try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ConfigManager.createDefaultConfig();
        }
    }

    private static void createDefaultConfig() {
        config = new ModConfig();
        ConfigManager.saveConfig();
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ModConfig {
        public boolean useLocalTime = true;
        public String cronExpression = "0 */30 * * * ?";
        public String messageFormat = "Ding! Current time is: {time}";
    }
}

