/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.nowtime.scheduler;

import com.yomi.nowtime.config.ConfigManager;
import com.yomi.nowtime.util.TimeProvider;
import java.text.ParseException;
import java.util.Date;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.quartz.CronExpression;

public class AnnouncementScheduler {
    private static CronExpression cron;
    private static Date nextTrigger;

    public static void initialize(MinecraftServer server) {
        try {
            cron = new CronExpression(ConfigManager.config.cronExpression);
            nextTrigger = cron.getNextValidTimeAfter(new Date());
        }
        catch (ParseException e) {
            server.method_43496((class_2561)class_2561.method_43470((String)"\u65e0\u6548\u7684cron\u8868\u8fbe\u5f0f\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c"));
            try {
                cron = new CronExpression("0 */60 * * * ?");
                nextTrigger = cron.getNextValidTimeAfter(new Date());
            }
            catch (ParseException ex) {
                throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa\u9ed8\u8ba4cron\u8868\u8fbe\u5f0f", ex);
            }
        }
        ServerTickEvents.END_SERVER_TICK.register(s -> {
            if (s.method_3780() % 20 == 0) {
                AnnouncementScheduler.checkSchedule(s);
            }
        });
    }

    private static void checkSchedule(MinecraftServer server) {
        Date now = new Date();
        if (now.after(nextTrigger)) {
            AnnouncementScheduler.broadcastTime(server);
            nextTrigger = cron.getNextValidTimeAfter(now);
        }
    }

    private static void broadcastTime(MinecraftServer server) {
        String time = TimeProvider.getFormattedTime(server);
        String message = ConfigManager.config.messageFormat.replace("{time}", time);
        server.method_3760().method_43514((class_2561)class_2561.method_43470((String)message), false);
    }
}

