/*
 * Decompiled with CFR 0.152.
 */
package com.yomi.nowtime.util;

import com.yomi.nowtime.config.ConfigManager;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.server.MinecraftServer;

public class TimeProvider {
    private static final DateTimeFormatter LOCAL_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static String getFormattedTime(MinecraftServer server) {
        if (ConfigManager.config.useLocalTime) {
            return LocalDateTime.now().format(LOCAL_FORMATTER);
        }
        return TimeProvider.getGameTime(server);
    }

    private static String getGameTime(MinecraftServer server) {
        long worldTime = server.method_30002().method_8532();
        long hours = (worldTime / 1000L + 6L) % 24L;
        long minutes = worldTime % 1000L * 60L / 1000L;
        return String.format("%02d:%02d", hours, minutes);
    }
}

