/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.brigadier.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.sponge.libs.cloud.CommandManager;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.CloudBrigadierCommand;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.CloudBrigadierManager;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.suggestion.TooltipSuggestion;
import org.empirewar.orbis.sponge.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.sponge.libs.cloud.internal.CommandNode;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.SuggestionFactory;

@API(status=API.Status.INTERNAL, since="2.0.0")
public final class BrigadierSuggestionFactory<C, S> {
    private final CloudBrigadierManager<C, S> cloudBrigadierManager;
    private final CommandManager<C> commandManager;
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    public BrigadierSuggestionFactory(@NonNull CloudBrigadierManager<C, S> cloudBrigadierManager, @NonNull CommandManager<C> commandManager, @NonNull SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory) {
        this.cloudBrigadierManager = cloudBrigadierManager;
        this.commandManager = commandManager;
        this.suggestionFactory = suggestionFactory;
    }

    public @NonNull CompletableFuture<@NonNull Suggestions> buildSuggestions(@NonNull CommandContext<S> senderContext, @Nullable CommandNode<C> parentNode, @NonNull SuggestionsBuilder builder) {
        C cloudSender = this.cloudBrigadierManager.senderMapper().map(senderContext.getSource());
        org.empirewar.orbis.sponge.libs.cloud.context.CommandContext<C> commandContext = new org.empirewar.orbis.sponge.libs.cloud.context.CommandContext<C>(true, cloudSender, this.commandManager);
        commandContext.store("_cloud_brigadier_native_sender", senderContext.getSource());
        String command = builder.getInput().substring(CloudBrigadierCommand.parsedNodes(senderContext.getLastChild()).get(0).second().getStart());
        String leading = command.split(" ")[0];
        if (leading.contains(":")) {
            command = command.substring(leading.split(":")[0].length() + 1);
        }
        return this.suggestionFactory.suggest(commandContext.sender(), command).thenApply(suggestionsResult -> {
            ArrayList suggestions = new ArrayList(suggestionsResult.list());
            if (parentNode != null) {
                Set siblingLiterals = parentNode.children().stream().map(CommandNode::component).filter(Objects::nonNull).filter(c -> c.type() == CommandComponent.ComponentType.LITERAL).flatMap(commandComponent -> commandComponent.aliases().stream()).collect(Collectors.toSet());
                suggestions.removeIf(suggestion -> siblingLiterals.contains(suggestion.suggestion()));
            }
            int trimmed = builder.getInput().length() - suggestionsResult.commandInput().length();
            int rawOffset = suggestionsResult.commandInput().cursor();
            SuggestionsBuilder suggestionsBuilder = builder.createOffset(rawOffset + trimmed);
            for (TooltipSuggestion suggestion2 : suggestions) {
                try {
                    suggestionsBuilder.suggest(Integer.parseInt(suggestion2.suggestion()), suggestion2.tooltip());
                }
                catch (NumberFormatException e) {
                    suggestionsBuilder.suggest(suggestion2.suggestion(), suggestion2.tooltip());
                }
            }
            return suggestionsBuilder.build();
        });
    }
}

