/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded;

import net.minecraft.client.Minecraft;
import net.minecraft.commands.SharedSuggestionProvider;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.SenderMapperHolder;
import org.empirewar.orbis.sponge.libs.cloud.key.CloudKey;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.permission.PermissionLevelResult;
import org.empirewar.orbis.sponge.libs.cloud.permission.PermissionResult;
import org.empirewar.orbis.sponge.libs.cloud.permission.PredicatePermission;

public final class ModdedPredicatePermissions {
    private ModdedPredicatePermissions() {
    }

    public static <C> @NonNull PredicatePermission<C> permissionLevel(final SenderMapperHolder<? extends SharedSuggestionProvider, C> mapperHolder, final int permissionLevel) {
        return new PredicatePermission<C>(){

            @Override
            public @NonNull PermissionResult testPermission(@NonNull C sender) {
                return PermissionLevelResult.of(((SharedSuggestionProvider)mapperHolder.senderMapper().reverse(sender)).hasPermission(permissionLevel), this, permissionLevel);
            }
        };
    }

    public static final class Client {
        private Client() {
        }

        public static <C> @NonNull PredicatePermission<C> integratedServerRunning() {
            return PredicatePermission.of(CloudKey.of("integrated-server-running"), sender -> Minecraft.getInstance().hasSingleplayerServer());
        }

        public static <C> @NonNull PredicatePermission<C> integratedServerNotRunning() {
            return PredicatePermission.of(CloudKey.of("integrated-server-not-running"), sender -> !Minecraft.getInstance().hasSingleplayerServer());
        }

        public static <C> @NonNull PredicatePermission<C> commandsAllowed() {
            return Client.commandsAllowed(true);
        }

        public static <C> @NonNull PredicatePermission<C> commandsAllowed(boolean allowOnMultiplayer) {
            return Client.commandsAllowed(PredicatePermission.of(sender -> allowOnMultiplayer));
        }

        public static <C> @NonNull PredicatePermission<C> commandsAllowed(final @NonNull PredicatePermission<C> allowOnMultiplayer) {
            return new PredicatePermission<C>(){
                private static final CloudKey<Void> KEY = CloudKey.of("commands-allowed");

                @Override
                public @NonNull CloudKey<Void> key() {
                    return KEY;
                }

                @Override
                public @NonNull PermissionResult testPermission(@NonNull C sender) {
                    if (!Minecraft.getInstance().hasSingleplayerServer()) {
                        return allowOnMultiplayer.testPermission(sender);
                    }
                    return PermissionResult.of(Minecraft.getInstance().getSingleplayerServer().getPlayerList().isAllowCommandsForAllPlayers() || Minecraft.getInstance().getSingleplayerServer().getWorldData().isAllowCommands(), this);
                }
            };
        }

        public static <C> @NonNull PredicatePermission<C> commandsDisallowed() {
            return Client.commandsDisallowed(true);
        }

        public static <C> @NonNull PredicatePermission<C> commandsDisallowed(boolean allowOnMultiplayer) {
            return Client.commandsDisallowed(PredicatePermission.of(sender -> allowOnMultiplayer));
        }

        public static <C> @NonNull PredicatePermission<C> commandsDisallowed(final @NonNull PredicatePermission<C> allowOnMultiplayer) {
            return new PredicatePermission<C>(){
                private static final CloudKey<Void> KEY = CloudKey.of("commands-disallowed");

                @Override
                public @NonNull CloudKey<Void> key() {
                    return KEY;
                }

                @Override
                public @NonNull PermissionResult testPermission(@NonNull C sender) {
                    if (!Minecraft.getInstance().hasSingleplayerServer()) {
                        return allowOnMultiplayer.testPermission(sender);
                    }
                    return PermissionResult.of(!Minecraft.getInstance().getSingleplayerServer().getPlayerList().isAllowCommandsForAllPlayers() && !Minecraft.getInstance().getSingleplayerServer().getWorldData().isAllowCommands(), this);
                }
            };
        }
    }
}

