/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.caption;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.caption.Caption;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionFormatter;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.caption.MinecraftVariable;

public final class MinecraftCaptionFormatter<C>
implements CaptionFormatter<C, Component> {
    private final Pattern pattern;

    public MinecraftCaptionFormatter(@NonNull Pattern pattern) {
        this.pattern = Objects.requireNonNull(pattern, "pattern");
    }

    public MinecraftCaptionFormatter() {
        this(CaptionFormatter.placeholderPattern());
    }

    @Override
    public @NonNull Component formatCaption(@NonNull Caption captionKey, @NonNull C recipient, @NonNull String caption, @NonNull List<@NonNull CaptionVariable> variables) {
        Map byKey = variables.stream().collect(Collectors.toMap(CaptionVariable::key, Function.identity()));
        MutableComponent component = Component.empty();
        String[] split = this.pattern.split(caption);
        Matcher matcher = this.pattern.matcher(caption);
        for (int i = 0; i < split.length; ++i) {
            component.append(split[i]);
            if (i == split.length - 1) continue;
            if (!matcher.find()) {
                throw new IllegalStateException();
            }
            String name = matcher.group(1);
            CaptionVariable variable = byKey.getOrDefault(name, CaptionVariable.of(name, matcher.group(0)));
            if (variable instanceof MinecraftVariable) {
                MinecraftVariable mc = (MinecraftVariable)variable;
                component.append(mc.componentValue());
                continue;
            }
            component.append(variable.value());
        }
        return component;
    }
}

