/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal;

import java.util.Objects;
import net.kyori.adventure.platform.modcommon.MinecraftAudiences;
import net.kyori.adventure.platform.modcommon.MinecraftClientAudiences;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.minecraft.server.MinecraftServer;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal.ComponentMessageThrowableConverter;

@API(status=API.Status.INTERNAL)
public final class AdventureSupport {
    private static final AdventureSupport INSTANCE = new AdventureSupport();
    private @Nullable MinecraftAudiences client;
    private @Nullable MinecraftAudiences server;

    private AdventureSupport() {
    }

    private void setupConverter() {
        try {
            ComponentMessageThrowableConverter.setup(this);
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    public void setupClient() {
        this.client = MinecraftClientAudiences.of();
    }

    public void setupServer(MinecraftServer server) {
        this.server = MinecraftServerAudiences.of((MinecraftServer)server);
    }

    public void removeServer(MinecraftServer server) {
        this.server = null;
    }

    public MinecraftAudiences audiences() {
        @Nullable MinecraftAudiences server = this.server;
        if (server == null) {
            return Objects.requireNonNull(this.client, "No audiences present");
        }
        return server;
    }

    public static AdventureSupport get() {
        return INSTANCE;
    }

    static {
        INSTANCE.setupConverter();
    }
}

