/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal;

import com.mojang.brigadier.arguments.ArgumentType;
import io.leangen.geantyref.TypeToken;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.util.Services;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.PlayerChatMessage;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.cloud.CommandManager;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.CloudBrigadierManager;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.signed.SignedGreedyStringParser;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.signed.SignedString;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.signed.SignedStringMapper;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;

@API(status=API.Status.INTERNAL)
public final class ModdedSignedStringMapper
implements SignedStringMapper {
    private final SignedStringFactory factory = ModdedSignedStringMapper.serviceWithFallback(SignedStringFactory.class);

    public void registerBrigadier(CommandManager<?> commandManager, Object brigManager) {
        ModdedSignedStringMapper.registerBrigadier((CloudBrigadierManager)brigManager);
    }

    private static <C> void registerBrigadier(CloudBrigadierManager<C, ?> manager) {
        manager.registerMapping(new TypeToken<SignedGreedyStringParser<C>>(){}, builder -> builder.toConstant((ArgumentType<?>)MessageArgument.message()).cloudSuggestions());
    }

    public CompletableFuture<ArgumentParseResult<SignedString>> apply(CommandContext<?> ctx, String str) {
        CommandSourceStack stack = (CommandSourceStack)ctx.get("_cloud_brigadier_native_sender");
        if (!(stack.getSigningContext() instanceof CommandSigningContext.SignedArguments)) {
            return ArgumentParseResult.successFuture(SignedString.unsigned((String)str));
        }
        Map signedArgs = ((CommandSigningContext.SignedArguments)stack.getSigningContext()).arguments();
        if (signedArgs.isEmpty()) {
            return ArgumentParseResult.successFuture(SignedString.unsigned((String)str));
        }
        if (signedArgs.size() != 1) {
            throw new IllegalStateException("Found more signed arguments than expected (" + signedArgs.size() + ")");
        }
        return ArgumentParseResult.successFuture(this.factory.create(str, (PlayerChatMessage)signedArgs.entrySet().iterator().next().getValue()));
    }

    private static <P> P serviceWithFallback(Class<P> type) {
        ServiceLoader<P> loader = ServiceLoader.load(type, type.getClassLoader());
        Iterator<P> it = loader.iterator();
        Throwable cause = null;
        P firstFallback = null;
        while (it.hasNext()) {
            P instance;
            try {
                instance = it.next();
            }
            catch (Throwable t2) {
                if (cause == null) {
                    cause = t2;
                    continue;
                }
                cause.addSuppressed(t2);
                continue;
            }
            if (instance instanceof Services.Fallback) {
                if (firstFallback != null) continue;
                firstFallback = instance;
                continue;
            }
            return instance;
        }
        if (firstFallback != null) {
            return firstFallback;
        }
        throw new IllegalStateException("Could not locate " + String.valueOf(type), cause);
    }

    public static interface SignedStringFactory {
        public SignedString create(String var1, PlayerChatMessage var2);
    }

    public static final class FallbackSignedStringFactory
    implements SignedStringFactory,
    Services.Fallback {
        @Override
        public SignedString create(String str, PlayerChatMessage signedMessage) {
            return SignedString.unsigned((String)str);
        }
    }
}

