/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.sponge;

import io.leangen.geantyref.TypeToken;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.flag.FeatureFlagSet;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.Command;
import org.empirewar.orbis.sponge.libs.cloud.brigadier.parser.WrappedBrigadierParser;
import org.empirewar.orbis.sponge.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.sponge.libs.cloud.internal.CommandNode;
import org.empirewar.orbis.sponge.libs.cloud.internal.CommandRegistrationHandler;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal.ContextualArgumentTypeProvider;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.MappedArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.aggregate.AggregateParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.standard.EitherParser;
import org.empirewar.orbis.sponge.libs.cloud.sponge.CloudSpongeCommand;
import org.empirewar.orbis.sponge.libs.cloud.sponge.SpongeCommandManager;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StartedEngineEvent;

final class SpongeRegistrationHandler<C>
implements CommandRegistrationHandler<C> {
    private SpongeCommandManager<C> commandManager;
    private final Set<Command<C>> registeredCommands = new HashSet<Command<C>>();

    SpongeRegistrationHandler() {
    }

    private void handleRegistrationEvent(RegisterCommandEvent<Command.Raw> event) {
        this.commandManager.registrationCalled();
        for (CommandNode node : this.commandManager.commandTree().rootNodes()) {
            this.registerCommand(event, Objects.requireNonNull(node.component()));
        }
    }

    private void registerCommand(RegisterCommandEvent<Command.Raw> event, CommandComponent<C> rootLiteral) {
        String label = rootLiteral.name();
        event.register(this.commandManager.owningPluginContainer(), new CloudSpongeCommand<C>(label, this.commandManager), label, rootLiteral.alternativeAliases().toArray(new String[0]));
    }

    private void startedEngine(StartedEngineEvent<Server> serverStartedEngineEvent) {
        MinecraftServer engine = (MinecraftServer)serverStartedEngineEvent.engine();
        ContextualArgumentTypeProvider.withBuildContext(this.commandManager, CommandBuildContext.simple((HolderLookup.Provider)engine.registryAccess(), (FeatureFlagSet)engine.getWorldData().enabledFeatures()), true, () -> {
            for (Command<C> registeredCommand : this.registeredCommands) {
                for (CommandComponent<C> component : registeredCommand.components()) {
                    if (component.type() == CommandComponent.ComponentType.LITERAL || component.type() == CommandComponent.ComponentType.FLAG) continue;
                    for (ArgumentParser<C, C> parser : SpongeRegistrationHandler.unwrap(component.parser())) {
                        if (!(parser instanceof WrappedBrigadierParser)) continue;
                        WrappedBrigadierParser wrappedBrigadierParser = (WrappedBrigadierParser)parser;
                        wrappedBrigadierParser.nativeArgumentType();
                    }
                }
            }
        });
    }

    void initialize(@NonNull SpongeCommandManager<C> commandManager) {
        this.commandManager = commandManager;
        Sponge.eventManager().registerListener(EventListenerRegistration.builder((TypeToken)new TypeToken<RegisterCommandEvent<Command.Raw>>(this){}).plugin(this.commandManager.owningPluginContainer()).listener(this::handleRegistrationEvent).order(Order.DEFAULT).build());
        Sponge.eventManager().registerListener(EventListenerRegistration.builder((TypeToken)new TypeToken<StartedEngineEvent<Server>>(this){}).plugin(this.commandManager.owningPluginContainer()).listener(this::startedEngine).order(Order.DEFAULT).build());
    }

    @Override
    public boolean registerCommand(@NonNull Command<C> command) {
        this.registeredCommands.add(command);
        return true;
    }

    private static Set<ArgumentParser<?, ?>> unwrap(ArgumentParser<?, ?> parser) {
        HashSet parsers = new HashSet();
        SpongeRegistrationHandler.unwrap(parsers, parser);
        return parsers;
    }

    private static void unwrap(Set<ArgumentParser<?, ?>> parsers, ArgumentParser<?, ?> parser) {
        if (parser instanceof MappedArgumentParser) {
            MappedArgumentParser mapped = (MappedArgumentParser)parser;
            SpongeRegistrationHandler.unwrap(parsers, mapped.baseParser());
            return;
        }
        if (parser instanceof EitherParser) {
            EitherParser eitherParser = (EitherParser)parser;
            SpongeRegistrationHandler.unwrap(parsers, eitherParser.primary().parser());
            SpongeRegistrationHandler.unwrap(parsers, eitherParser.fallback().parser());
            return;
        }
        if (parser instanceof AggregateParser) {
            AggregateParser aggregateParser = (AggregateParser)parser;
            for (CommandComponent component : aggregateParser.components()) {
                SpongeRegistrationHandler.unwrap(parsers, component.parser());
            }
            return;
        }
        parsers.add(parser);
    }
}

