/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Optional;

public record EnumCodec<E extends Enum<E>>(Class<E> clazz) implements PrimitiveCodec<E>
{
    public <T> DataResult<E> read(DynamicOps<T> dynamicOps, T t2) {
        DataResult res = dynamicOps.getStringValue(t2);
        Optional result = res.result();
        if (res.error().isPresent() || result.isEmpty()) {
            return DataResult.error(() -> "Unable to parse EnumCodec for \"" + this.clazz.getSimpleName() + "\": " + (res.error().isPresent() ? ((DataResult.Error)res.error().get()).message() : "(no error)"), (Lifecycle)Lifecycle.stable());
        }
        Optional<Enum> value = Optional.empty();
        for (Enum enumConstant : (Enum[])this.clazz.getEnumConstants()) {
            if (!enumConstant.name().equals(result.get())) continue;
            value = Optional.of(enumConstant);
            break;
        }
        return value.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unable to parse EnumCodec for \"" + this.clazz.getSimpleName() + "\": Unknown enum value \"" + (String)result.get() + "\"", (Lifecycle)Lifecycle.stable()));
    }

    public <T> T write(DynamicOps<T> dynamicOps, E e) {
        return (T)dynamicOps.createString(((Enum)e).name());
    }

    static <E extends Enum<E>> DataResult<E> validate(String name, E[] enumValues) {
        for (E e : enumValues) {
            if (!((Enum)e).name().equals(name)) continue;
            return DataResult.success(e);
        }
        return DataResult.error(() -> String.format("\"%s\" has no enum value \"%s\"!", "", name), (Lifecycle)Lifecycle.stable());
    }
}

