/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.world;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.area.EncompassingArea;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.sponge.libs.rtree.Entry;
import org.empirewar.orbis.sponge.libs.rtree.RTree;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Geometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Rectangle;
import org.empirewar.orbis.world.RegionisedWorld;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.joml.Vector3ic;

public final class RegionisedWorldSet
implements RegionisedWorld {
    private final Key worldId;
    private final Set<Region> regions;
    private final Map<Region, GeometryEntry> regionGeometries;
    private RTree<Region, Geometry> regionRTree;

    public RegionisedWorldSet() {
        this(null);
    }

    public RegionisedWorldSet(@Nullable Key worldId) {
        this.worldId = worldId;
        this.regions = ConcurrentHashMap.newKeySet();
        this.regionRTree = RTree.dimensions(3).create();
        this.regionGeometries = new ConcurrentHashMap<Region, GeometryEntry>();
    }

    @Override
    public Optional<Key> worldId() {
        return Optional.ofNullable(this.worldId);
    }

    @Override
    public RegionQuery.FilterableRegionResult<RegionQuery.Position> query(RegionQuery.Position position) {
        Vector3dc pos = position.position();
        Rectangle pointRect = Rectangle.create((float)pos.x(), (float)pos.y(), (float)pos.z(), (float)pos.x(), (float)pos.y(), (float)pos.z());
        LinkedHashSet<Region> result = new LinkedHashSet<Region>();
        for (Entry<Region, Geometry> entry : this.regionRTree.search(pointRect)) {
            Region region = entry.value();
            if (!region.area().contains(pos)) continue;
            result.add(region);
        }
        for (Region region : this.regions) {
            if (!region.isGlobal()) continue;
            result.add(region);
        }
        ArrayList sorted = new ArrayList(result);
        sorted.sort(Comparator.reverseOrder());
        return position.resultBuilder().query(position).result(new LinkedHashSet(sorted)).build();
    }

    @Override
    public Set<Region> regions() {
        return this.regions;
    }

    @Override
    public Optional<Region> getByName(String regionName) {
        return this.regions.stream().filter(region -> region.name().equals(regionName)).findAny();
    }

    @Override
    public boolean add(Region region) {
        if (this.regions.add(region)) {
            if (!region.isGlobal()) {
                this.updateBoundingBox(region);
            }
            return true;
        }
        return false;
    }

    private void updateBoundingBox(Region region) {
        Rectangle newRect;
        if (!this.regions.contains(region)) {
            return;
        }
        if (region.isGlobal()) {
            throw new IllegalArgumentException("Cannot update global region");
        }
        EncompassingArea area = (EncompassingArea)region.area();
        GeometryEntry oldGeometry = this.regionGeometries.remove(region);
        if (oldGeometry != null) {
            area.removeUpdateListener(oldGeometry.listener());
            if (oldGeometry.geometry() != null) {
                this.regionRTree = this.regionRTree.delete(region, oldGeometry.geometry());
            }
        }
        if ((newRect = this.createBoundingBox(area)) != null) {
            this.regionRTree = this.regionRTree.add(region, newRect);
        }
        Runnable updateListener = () -> this.updateBoundingBox(region);
        area.addUpdateListener(updateListener);
        this.regionGeometries.put(region, new GeometryEntry(newRect, updateListener));
    }

    @Nullable
    private Rectangle createBoundingBox(Area area) {
        if (area.points().isEmpty()) {
            return null;
        }
        Vector3ic min2 = area.getMin();
        Vector3ic max = area.getMax();
        return Rectangle.create(min2.x(), min2.y(), min2.z(), (float)max.x() + 1.0f, (float)max.y() + 1.0f, (float)max.z() + 1.0f);
    }

    @Override
    public boolean remove(Region region) {
        if (region.isGlobal() && this.worldId != null && region.name().equals(this.worldId.asString())) {
            throw new IllegalArgumentException("Cannot remove global region of the world");
        }
        if (this.regions.remove(region)) {
            GeometryEntry geometry;
            if (!region.isGlobal() && (geometry = this.regionGeometries.remove(region)) != null) {
                EncompassingArea area = (EncompassingArea)region.area();
                area.removeUpdateListener(geometry.listener());
                if (geometry.geometry() != null) {
                    this.regionRTree = this.regionRTree.delete(region, geometry.geometry());
                }
            }
            return true;
        }
        return false;
    }

    private record GeometryEntry(@Nullable Geometry geometry, Runnable listener) {
    }
}

