/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.fabric.selection;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.util.OrbisText;
import org.empirewar.orbis.util.OrbisTranslations;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class SelectionListener {
    private final Orbis api;

    public SelectionListener(Orbis api) {
        this.api = api;
        AttackBlockCallback.EVENT.register(this::onLeftClick);
        UseItemCallback.EVENT.register(this::onRightClick);
    }

    private class_1269 onRightClick(class_1657 player, class_1937 level, class_1268 interactionHand) {
        if (!Permissions.check((class_1297)player, (String)"orbis.manage", (int)3)) {
            return class_1269.field_5811;
        }
        class_1799 item = player.method_5998(interactionHand);
        if (item.method_7960() || !((class_9279)item.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10545("orbis_is_wand")) {
            return class_1269.field_5811;
        }
        Selection selection = this.api.selectionManager().get(player.method_5667()).orElse(null);
        if (selection == null) {
            ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_NOT_ACTIVE));
            return class_1269.field_5811;
        }
        Vector3ic last = selection.getPoints().stream().reduce((first, second) -> second).orElse(null);
        if (last == null) {
            return class_1269.field_5811;
        }
        selection.removePoint(last);
        ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_REMOVED));
        return class_1269.field_5812;
    }

    private class_1269 onLeftClick(class_1657 player, class_1937 level, class_1268 interactionHand, class_2338 blockPos, class_2350 direction) {
        Vector3i point;
        if (!Permissions.check((class_1297)player, (String)"orbis.manage", (int)3)) {
            return class_1269.field_5811;
        }
        class_1799 item = player.method_5998(interactionHand);
        if (item.method_7960() || !((class_9279)item.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10545("orbis_is_wand")) {
            return class_1269.field_5811;
        }
        Selection selection = this.api.selectionManager().get(player.method_5667()).orElseGet(() -> {
            Selection newSelection = new Selection(AreaType.CUBOID);
            this.api.selectionManager().add(player.method_5667(), newSelection);
            ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)"Started a new cuboid selection.", (TextColor)OrbisText.EREBOR_GREEN)));
            return newSelection;
        });
        class_2680 block = level.method_8320(blockPos);
        if (block.method_26215()) {
            class_2338 playerPos = player.method_24515();
            point = new Vector3i(playerPos.method_10263(), playerPos.method_10264(), playerPos.method_10260());
        } else {
            point = new Vector3i(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        }
        selection.addPoint((Vector3ic)point);
        ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_ADDED.arguments(new ComponentLike[]{Component.text((int)point.x), Component.text((int)point.y), Component.text((int)point.z)})).hoverEvent((HoverEventSource)HoverEvent.showText((Component)OrbisTranslations.GENERIC_CLICK_TO_TELEPORT)).clickEvent(ClickEvent.callback(audience -> player.method_5859((double)point.x, (double)point.y, (double)point.z), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(3L)).build()))));
        return class_1269.field_5814;
    }
}

