/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.query;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.query.RegionQuery;

class RegionQueryFlagBuilder<FR>
implements RegionQuery.Flag.Builder<FR> {
    private RegistryRegionFlag<FR> flag;
    private UUID player;

    RegionQueryFlagBuilder() {
    }

    @Override
    public RegionQuery.Flag<FR> build() {
        Preconditions.checkState((this.flag != null ? 1 : 0) != 0, (Object)"Flag cannot be empty");
        return new RegionQuery.Flag<FR>(){

            @Override
            public RegistryRegionFlag<FR> flag() {
                return RegionQueryFlagBuilder.this.flag;
            }

            @Override
            public Optional<UUID> player() {
                return Optional.ofNullable(RegionQueryFlagBuilder.this.player);
            }
        };
    }

    @Override
    public RegionQuery.Flag.Builder<FR> flag(RegistryRegionFlag<FR> flag) {
        Objects.requireNonNull(flag, "Flag cannot be null");
        this.flag = flag;
        return this;
    }

    @Override
    public RegionQuery.Flag.Builder<FR> player(UUID player) {
        Objects.requireNonNull(player, "Player cannot be null");
        this.player = player;
        return this;
    }
}

