/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import io.leangen.geantyref.TypeToken;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.flag.value.FlagValue;
import org.empirewar.orbis.flag.value.FlagValueParseResult;
import org.empirewar.orbis.serialization.FlagValueAdapter;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserParameters;
import org.incendo.cloud.parser.ParserRegistry;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionProvider;

public record FlagValueParser<C>(CommandManager<?> manager) implements ArgumentParser.FutureArgumentParser<C, FlagValue<?>>,
SuggestionProvider<C>
{
    private static final Pattern FLAG_PATTERN = Pattern.compile("(-[A-Za-z_\\-0-9])|(--[A-Za-z_\\-0-9]*)");

    public @NonNull CompletableFuture<@NonNull ArgumentParseResult<FlagValue<?>>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = (String)this.parseGreedy(commandInput).parsedValue().orElseThrow();
        RegistryRegionFlag flag = (RegistryRegionFlag)commandContext.get("flag");
        Gson gson = new GsonBuilder().registerTypeAdapter(FlagValueParseResult.class, new FlagValueAdapter(flag)).create();
        try {
            FlagValueParseResult parsed = (FlagValueParseResult)gson.fromJson(input, FlagValueParseResult.class);
            DataResult<?> get = parsed.result();
            if (get.isError()) {
                return ArgumentParseResult.failureFuture((Throwable)((Object)new FlagValueParserException(input, ((DataResult.Error)get.error().orElseThrow()).message(), commandContext)));
            }
            return ArgumentParseResult.successFuture(new FlagValue(get.result().orElseThrow()));
        }
        catch (JsonSyntaxException e) {
            return ArgumentParseResult.failureFuture((Throwable)((Object)new FlagValueParserException(input, e.getMessage(), commandContext)));
        }
    }

    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        RegistryRegionFlag flag = (RegistryRegionFlag)context.get("flag");
        ParserRegistry parserRegistry = this.manager.parserRegistry();
        Optional parser = parserRegistry.createParser(TypeToken.get(flag.defaultValueType()), ParserParameters.empty());
        if (parser.isPresent()) {
            return ((ArgumentParser)parser.get()).suggestionProvider().suggestionsFuture(context, input);
        }
        return CompletableFuture.completedFuture(List.of());
    }

    private @NonNull ArgumentParseResult<String> parseGreedy(@NonNull CommandInput commandInput) {
        String string;
        int size = commandInput.remainingTokens();
        StringJoiner stringJoiner = new StringJoiner(" ");
        for (int i = 0; i < size && !(string = commandInput.peekString()).isEmpty() && !FLAG_PATTERN.matcher(string).matches(); ++i) {
            stringJoiner.add(commandInput.readStringSkipWhitespace(false));
        }
        return ArgumentParseResult.success((Object)stringJoiner.toString());
    }

    public static final class FlagValueParserException
    extends ParserException {
        public FlagValueParserException(@NonNull String input, String error, @NonNull CommandContext<?> context) {
            super(FlagValueParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_VALUE_INVALID, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input), CaptionVariable.of((String)"error", (String)error)});
        }
    }
}

