/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.datafixer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.datafixer.Schemas;

public final class OrbisDataFixes {
    private static final String VERSION_KEY = "data_version";

    private OrbisDataFixes() {
    }

    public static @Nullable JsonElement updateFixerVersion(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        element.getAsJsonObject().addProperty(VERSION_KEY, (Number)1);
        return element;
    }

    public static int getFixerVersion(@NonNull JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        if (object.has(VERSION_KEY)) {
            return object.get(VERSION_KEY).getAsInt();
        }
        return 1;
    }

    public static JsonElement fix(DSL.TypeReference typeReference, @NonNull JsonObject object) {
        if (!Schemas.FIXER.getSchema(DataFixUtils.makeKey((int)1)).types().contains(typeReference.typeName())) {
            OrbisAPI.get().logger().debug("Not updating {}", (Object)typeReference.typeName());
            return object;
        }
        int currentVer = OrbisDataFixes.getFixerVersion((JsonElement)object);
        if (1 == currentVer) {
            return object;
        }
        OrbisAPI.get().logger().debug("Updating {} from version {} to version {}", new Object[]{typeReference.typeName(), currentVer, 1});
        Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object);
        return (JsonElement)Schemas.FIXER.update(typeReference, dynamic, currentVer, 1).getValue();
    }
}

