/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.fabric;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.fabric.api.event.RegionEnterEvent;
import org.empirewar.orbis.fabric.api.event.RegionLeaveEvent;
import org.empirewar.orbis.fabric.event.PlayerMoveEvent;
import org.empirewar.orbis.fabric.event.PlayerTeleportEvent;
import org.empirewar.orbis.fabric.listener.BlockActionListener;
import org.empirewar.orbis.fabric.listener.ConnectionListener;
import org.empirewar.orbis.fabric.listener.InteractEntityListener;
import org.empirewar.orbis.fabric.selection.SelectionListener;
import org.empirewar.orbis.fabric.session.FabricConsoleSession;
import org.empirewar.orbis.fabric.session.FabricPlayerSession;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.modded.command.ModdedCommands;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.world.RegionisedWorld;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbisFabric
extends OrbisPlatform
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"orbis");
    private volatile MinecraftServerAudiences adventure;
    private class_1799 wandItem;
    private Path dataFolder;
    private volatile MinecraftServer server;

    public MinecraftServerAudiences adventure() {
        MinecraftServerAudiences ret = this.adventure;
        if (ret == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return ret;
    }

    public class_1799 getWandItem() {
        return this.wandItem.method_7972();
    }

    public MinecraftServer server() {
        return this.server;
    }

    public void onInitialize() {
        this.dataFolder = FabricLoader.getInstance().getConfigDir().resolve("orbis");
        this.load();
        new ModdedCommands<FabricServerCommandManager>(new FabricServerCommandManager(ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(sender -> {
            class_3222 patt0$temp = sender.method_44023();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = patt0$temp;
                return new FabricPlayerSession(player, (class_2168)sender);
            }
            return new FabricConsoleSession((class_2168)sender);
        }, session -> {
            if (session instanceof FabricPlayerSession) {
                FabricPlayerSession playerSession = (FabricPlayerSession)session;
                return playerSession.getCause();
            }
            return ((FabricConsoleSession)session).cause();
        })));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.adventure = MinecraftServerAudiences.of((MinecraftServer)server);
            this.server = server;
            this.registerListeners();
            try {
                this.loadRegions();
            }
            catch (IOException e) {
                this.logger().error("Error loading regions", (Throwable)e);
            }
            this.wandItem = new class_1799((class_1935)class_1802.field_8894);
            this.wandItem.method_57379(class_9334.field_50239, (Object)this.adventure.asNative(Selection.WAND_NAME));
            this.wandItem.method_57379(class_9334.field_49632, (Object)new class_9290(Selection.WAND_LORE.stream().map(arg_0 -> ((MinecraftServerAudiences)this.adventure).asNative(arg_0)).toList()));
            class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)this.wandItem, compoundTag -> {
                class_2487 tag = new class_2487();
                tag.method_10556("orbis_is_wand", true);
                compoundTag.method_10543(tag);
            });
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            try {
                this.saveRegions();
            }
            catch (IOException e) {
                this.logger().error("Error saving regions", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.adventure = null;
            this.server = null;
        });
    }

    private void registerListeners() {
        ServerWorldEvents.UNLOAD.register((s, world) -> this.saveWorld(world.method_27983().key(), UUID.randomUUID()));
        ServerWorldEvents.LOAD.register((s, world) -> this.loadWorld(world.method_27983().key(), UUID.randomUUID()));
        RegionEnterEvent.EVENT.register((player, level, pos, world, region) -> region.query(RegionQuery.Flag.builder(DefaultFlags.ENTRY_MESSAGE)).result().ifPresent(message -> ((Audience)player).sendMessage(this.miniMessage().deserialize(message))));
        RegionLeaveEvent.EVENT.register((player, level, pos, world, region) -> region.query(RegionQuery.Flag.builder(DefaultFlags.EXIT_MESSAGE)).result().ifPresent(message -> ((Audience)player).sendMessage(this.miniMessage().deserialize(message))));
        PlayerMoveEvent.EVENT.register((player, level, from, to) -> {
            RegionisedWorld world = OrbisAPI.get().getRegionisedWorld(player.method_37908().method_27983().key());
            RegionQuery.FilterableRegionResult<RegionQuery.Position> toQuery = world.query(RegionQuery.Position.builder().position(to.method_10216(), to.method_10214(), to.method_10215()));
            boolean canMove = toQuery.query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.method_5667())).result().orElse(true);
            if (!canMove) {
                return true;
            }
            RegionQuery.FilterableRegionResult<RegionQuery.Position> fromQuery = world.query(RegionQuery.Position.builder().position(from.method_10216(), from.method_10214(), from.method_10215()));
            Set toRegions = (Set)toQuery.result();
            Set fromRegions = (Set)fromQuery.result();
            for (Region possiblyEntered : toRegions) {
                if (fromRegions.contains(possiblyEntered)) continue;
                ((RegionEnterEvent)RegionEnterEvent.EVENT.invoker()).enter(player, player.method_37908(), to, world, possiblyEntered);
            }
            for (Region possiblyLeft : fromRegions) {
                if (toRegions.contains(possiblyLeft)) continue;
                ((RegionLeaveEvent)RegionLeaveEvent.EVENT.invoker()).leave(player, player.method_37908(), to, world, possiblyLeft);
            }
            return false;
        });
        PlayerTeleportEvent.EVENT.register((player, level, pos) -> {
            RegionisedWorld world = this.getRegionisedWorld(player.method_37908().method_27983().key());
            boolean canMove = world.query(RegionQuery.Position.builder().position(pos.method_10216(), pos.method_10214(), pos.method_10215())).query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.method_5667())).result().orElse(true);
            return !canMove;
        });
        new SelectionListener(this);
        new ConnectionListener(this);
        new InteractEntityListener(this);
        new BlockActionListener(this);
    }

    @Override
    public Key getPlayerWorld(UUID player) {
        return this.server.method_3760().method_14602(player).method_51469().method_27983().key();
    }

    @Override
    public boolean hasPermission(UUID player, String permission) {
        class_3222 vanilla = this.server.method_3760().method_14602(player);
        if (vanilla == null) {
            return false;
        }
        return Permissions.check((class_1297)vanilla, (String)permission);
    }

    @Override
    public Path dataFolder() {
        return this.dataFolder;
    }

    @Override
    protected InputStream getResourceAsStream(String path) {
        return this.getClass().getResourceAsStream(path);
    }

    @Override
    public Logger logger() {
        return LOGGER;
    }
}

