/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.area.EncompassingArea;
import org.empirewar.orbis.util.ExtraCodecs;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class CuboidArea
extends EncompassingArea {
    public static final MapCodec<CuboidArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.VEC_3I.listOf().fieldOf("points").forGetter(c -> c.points.stream().toList())).apply((Applicative)instance, CuboidArea::new));

    public CuboidArea() {
    }

    private CuboidArea(List<Vector3ic> points) {
        super(points);
    }

    @Override
    public boolean contains(Vector3dc point) {
        return this.contains(point.x(), point.y(), point.z());
    }

    @Override
    public boolean contains(double x, double y, double z) {
        if (this.points.size() != this.getMaximumPoints().orElseThrow().intValue()) {
            return false;
        }
        return x >= (double)this.min.x() && x <= (double)this.max.x() && y >= (double)this.min.y() && y <= (double)this.max.y() && z >= (double)this.min.z() && z <= (double)this.max.z();
    }

    @Override
    public AreaType<?> getType() {
        return AreaType.CUBOID;
    }

    @Override
    public Optional<Integer> getMaximumPoints() {
        return Optional.of(2);
    }

    @Override
    public int getMinimumPoints() {
        return 2;
    }

    @Override
    public Set<Vector3ic> generateBoundaryPoints() {
        HashSet<Vector3ic> points = new HashSet<Vector3ic>();
        if (this.points().size() < 2) {
            return points;
        }
        Vector3ic min2 = this.getMin();
        Vector3ic max = this.getMax();
        this.addLine(points, min2.x(), min2.y(), min2.z(), max.x(), min2.y(), min2.z());
        this.addLine(points, max.x(), min2.y(), min2.z(), max.x(), max.y(), min2.z());
        this.addLine(points, max.x(), max.y(), min2.z(), min2.x(), max.y(), min2.z());
        this.addLine(points, min2.x(), max.y(), min2.z(), min2.x(), min2.y(), min2.z());
        this.addLine(points, min2.x(), min2.y(), max.z(), max.x(), min2.y(), max.z());
        this.addLine(points, max.x(), min2.y(), max.z(), max.x(), max.y(), max.z());
        this.addLine(points, max.x(), max.y(), max.z(), min2.x(), max.y(), max.z());
        this.addLine(points, min2.x(), max.y(), max.z(), min2.x(), min2.y(), max.z());
        this.addLine(points, min2.x(), min2.y(), min2.z(), min2.x(), min2.y(), max.z());
        this.addLine(points, max.x(), min2.y(), min2.z(), max.x(), min2.y(), max.z());
        this.addLine(points, min2.x(), max.y(), min2.z(), min2.x(), max.y(), max.z());
        this.addLine(points, max.x(), max.y(), min2.z(), max.x(), max.y(), max.z());
        return points;
    }

    private void addLine(Set<Vector3ic> points, int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = Integer.compare(x2, x1);
        int dy = Integer.compare(y2, y1);
        int dz = Integer.compare(z2, z1);
        int length = Math.max(Math.max(Math.abs(x2 - x1), Math.abs(y2 - y1)), Math.abs(z2 - z1));
        for (int i = 0; i <= length; ++i) {
            int x = x1 + dx * i;
            int y = y1 + dy * i;
            int z = z1 + dz * i;
            points.add((Vector3ic)new Vector3i(x, y, z));
        }
    }
}

