/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.caffeine;

import org.empirewar.orbis.paper.libs.caffeine.AsyncCacheLoader;
import org.empirewar.orbis.paper.libs.caffeine.Caffeine;
import org.empirewar.orbis.paper.libs.caffeine.Expiry;
import org.empirewar.orbis.paper.libs.caffeine.LocalCacheFactory;
import org.empirewar.orbis.paper.libs.caffeine.Pacer;
import org.empirewar.orbis.paper.libs.caffeine.SSSMS;
import org.empirewar.orbis.paper.libs.caffeine.Scheduler;
import org.empirewar.orbis.paper.libs.caffeine.Ticker;
import org.empirewar.orbis.paper.libs.caffeine.TimerWheel;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;

class SSSMSA<K, V>
extends SSSMS<K, V> {
    static final LocalCacheFactory FACTORY = SSSMSA::new;
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    SSSMSA(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected boolean fastpath() {
        return false;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

