/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.annotations.string;

import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.paper.libs.cloud.annotations.string.PatternReplacingStringProcessor;

public class PropertyReplacingStringProcessor
extends PatternReplacingStringProcessor {
    public static final Pattern PROPERTY_REGEX = Pattern.compile("\\$\\{(\\S+)}");

    public PropertyReplacingStringProcessor(@NonNull Function<@NonNull String, @Nullable String> replacementProvider) {
        super(PROPERTY_REGEX, new PropertyReplacementProvider(replacementProvider));
    }

    private static final class PropertyReplacementProvider
    implements Function<MatchResult, String> {
        private final Function<String, String> replacementProvider;

        private PropertyReplacementProvider(@NonNull Function<String, String> replacementProvider) {
            this.replacementProvider = replacementProvider;
        }

        @Override
        public @Nullable String apply(@NonNull MatchResult matchResult) {
            return this.replacementProvider.apply(matchResult.group(1));
        }
    }
}

