/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.suggestion;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.context.CommandContext;
import org.empirewar.orbis.paper.libs.cloud.suggestion.MappingSuggestionFactory;
import org.empirewar.orbis.paper.libs.cloud.suggestion.Suggestion;
import org.empirewar.orbis.paper.libs.cloud.suggestion.SuggestionMapper;
import org.empirewar.orbis.paper.libs.cloud.suggestion.Suggestions;

@API(status=API.Status.STABLE)
public interface SuggestionFactory<C, S extends Suggestion> {
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull CommandContext<C> var1, @NonNull String var2);

    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull C var1, @NonNull String var2);

    default public @NonNull Suggestions<C, S> suggestImmediately(@NonNull C sender, @NonNull String input) {
        try {
            return this.suggest(sender, input).join();
        }
        catch (CompletionException completionException) {
            Throwable cause = completionException.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw completionException;
        }
    }

    default public <S2 extends Suggestion> @NonNull SuggestionFactory<C, S2> mapped(@NonNull SuggestionMapper<S2> mapper) {
        return new MappingSuggestionFactory(this, mapper);
    }
}

