/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.area;

import com.mojang.serialization.MapCodec;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.area.CuboidArea;
import org.empirewar.orbis.area.PolygonArea;
import org.empirewar.orbis.area.PolyhedralArea;
import org.empirewar.orbis.area.SphericalArea;
import org.empirewar.orbis.registry.KeyOrbisRegistry;
import org.empirewar.orbis.registry.OrbisRegistries;

public interface AreaType<A extends Area> {
    public static final AreaType<CuboidArea> CUBOID = AreaType.register("cuboid", CuboidArea.CODEC);
    public static final AreaType<PolygonArea> POLYGON = AreaType.register("polygon", PolygonArea.CODEC);
    public static final AreaType<PolyhedralArea> POLYHEDRAL = AreaType.register("polyhedral", PolyhedralArea.CODEC);
    public static final AreaType<SphericalArea> SPHERE = AreaType.register("sphere", SphericalArea.CODEC);

    public MapCodec<A> codec();

    private static <A extends Area> AreaType<A> register(String id, MapCodec<A> codec) {
        return KeyOrbisRegistry.register(OrbisRegistries.AREA_TYPE, id, () -> codec);
    }
}

