/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser;

import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.BlockingSuggestionProvider;
import org.empirewar.orbis.world.RegionisedWorld;

public final class RegionisedWorldParser<C>
implements ArgumentParser<C, RegionisedWorld>,
BlockingSuggestionProvider.Strings<C> {
    @Override
    public @NonNull ArgumentParseResult<@NonNull RegionisedWorld> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        for (RegionisedWorld regionisedWorld : OrbisAPI.get().getRegionisedWorlds()) {
            if (!regionisedWorld.worldId().orElseThrow().asString().equalsIgnoreCase(input)) continue;
            commandInput.readString();
            return ArgumentParseResult.success(regionisedWorld);
        }
        return ArgumentParseResult.failure(new RegionisedWorldParserException(input, commandContext));
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return OrbisAPI.get().getRegionisedWorlds().stream().map(rw -> rw.worldId().orElseThrow().asString()).toList();
    }

    public static final class RegionisedWorldParserException
    extends ParserException {
        private final String input;

        public RegionisedWorldParserException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(RegionisedWorldParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_WORLD_NOT_FOUND, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

