/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.exception.parsing;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.sponge.libs.cloud.caption.Caption;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionFormatter;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;

@API(status=API.Status.STABLE)
public class ParserException
extends IllegalArgumentException {
    private final Class<?> argumentParser;
    private final CommandContext<?> context;
    private final Caption errorCaption;
    private final CaptionVariable[] captionVariables;

    protected ParserException(@Nullable Throwable cause, @NonNull Class<?> argumentParser, @NonNull CommandContext<?> context, @NonNull Caption errorCaption, CaptionVariable ... captionVariables) {
        super(cause);
        this.argumentParser = argumentParser;
        this.context = context;
        this.errorCaption = errorCaption;
        this.captionVariables = captionVariables;
    }

    protected ParserException(@NonNull Class<?> argumentParser, @NonNull CommandContext<?> context, @NonNull Caption errorCaption, CaptionVariable ... captionVariables) {
        this(null, argumentParser, context, errorCaption, captionVariables);
    }

    @Override
    public final String getMessage() {
        return this.context.formatCaption(this.errorCaption, this.captionVariables);
    }

    @API(status=API.Status.STABLE)
    public final <T> @NonNull T formatCaption(@NonNull CaptionFormatter<?, T> formatter) {
        return this.context.formatCaption(formatter, this.errorCaption, this.captionVariables());
    }

    @API(status=API.Status.STABLE)
    public @NonNull Caption errorCaption() {
        return this.errorCaption;
    }

    @API(status=API.Status.STABLE)
    public @NonNull CaptionVariable @NonNull [] captionVariables() {
        return Arrays.copyOf(this.captionVariables, this.captionVariables.length);
    }

    public final @NonNull Class<?> argumentParserClass() {
        return this.argumentParser;
    }

    public final @NonNull CommandContext<?> context() {
        return this.context;
    }
}

