/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.internal;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.checker.framework.qual.DefaultQualifier;
import org.empirewar.orbis.sponge.libs.cloud.CommandManager;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionFormatter;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.sponge.libs.cloud.caption.StandardCaptionKeys;
import org.empirewar.orbis.sponge.libs.cloud.exception.ArgumentParseException;
import org.empirewar.orbis.sponge.libs.cloud.exception.CommandExecutionException;
import org.empirewar.orbis.sponge.libs.cloud.exception.InvalidCommandSenderException;
import org.empirewar.orbis.sponge.libs.cloud.exception.InvalidSyntaxException;
import org.empirewar.orbis.sponge.libs.cloud.exception.NoPermissionException;
import org.empirewar.orbis.sponge.libs.cloud.exception.NoSuchCommandException;
import org.empirewar.orbis.sponge.libs.cloud.exception.handling.ExceptionContext;
import org.empirewar.orbis.sponge.libs.cloud.exception.handling.ExceptionHandler;
import org.empirewar.orbis.sponge.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.ModdedCommandContextKeys;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.caption.MinecraftVariable;
import org.empirewar.orbis.sponge.libs.cloud.util.TypeUtils;
import org.slf4j.Logger;

@API(status=API.Status.INTERNAL)
@FunctionalInterface
@DefaultQualifier(value=NonNull.class)
public interface ModdedExceptionHandler<C, S extends SharedSuggestionProvider, T extends Throwable>
extends ExceptionHandler<C, T> {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Component NEWLINE = Component.literal((String)"\n");

    @Override
    default public void handle(ExceptionContext<C, T> context) throws Throwable {
        SharedSuggestionProvider source = context.context().get(ModdedCommandContextKeys.SHARED_SUGGESTION_PROVIDER);
        this.handle(source, context);
    }

    public void handle(S var1, ExceptionContext<C, T> var2) throws Throwable;

    public static <C, M extends CommandManager<C>> void registerDefaults(M commandManager, CaptionFormatter<C, Component> captionFormatter) {
        ModdedExceptionHandler.registerDefaults(commandManager, CommandSourceStack::sendFailure, CommandSourceStack::getTextName, captionFormatter);
    }

    public static <C, S extends SharedSuggestionProvider, M extends CommandManager<C>> void registerDefaults(M commandManager, BiConsumer<S, Component> sendError, Function<S, String> getName, CaptionFormatter<C, Component> captionFormatter) {
        RegisterContext<C, SharedSuggestionProvider> ctx = new RegisterContext<C, SharedSuggestionProvider>(commandManager);
        ctx.registerHandler(Throwable.class, (source, exceptionContext) -> {
            sendError.accept(source, ModdedExceptionHandler.decorateHoverStacktrace(commandManager, (Component)exceptionContext.context().formatCaption(captionFormatter, StandardCaptionKeys.EXCEPTION_UNEXPECTED, new CaptionVariable[0]), exceptionContext.exception(), exceptionContext.context().sender()));
            LOGGER.warn("Error occurred while executing command for user {}", getName.apply(source), exceptionContext.exception());
        });
        ctx.registerHandler(CommandExecutionException.class, (source, exceptionContext) -> {
            sendError.accept(source, ModdedExceptionHandler.decorateHoverStacktrace(commandManager, (Component)exceptionContext.context().formatCaption(captionFormatter, StandardCaptionKeys.EXCEPTION_UNEXPECTED, new CaptionVariable[0]), ((CommandExecutionException)exceptionContext.exception()).getCause(), exceptionContext.context().sender()));
            LOGGER.warn("Error occurred while executing command for user {}", getName.apply(source), (Object)((CommandExecutionException)exceptionContext.exception()).getCause());
        });
        ctx.registerHandler(ArgumentParseException.class, (source, exceptionContext) -> {
            Component msg;
            Throwable patt0$temp = ((ArgumentParseException)exceptionContext.exception()).getCause();
            if (patt0$temp instanceof CommandSyntaxException) {
                CommandSyntaxException cse = (CommandSyntaxException)patt0$temp;
                msg = ComponentUtils.fromMessage((Message)cse.getRawMessage());
            } else {
                Throwable patt1$temp = ((ArgumentParseException)exceptionContext.exception()).getCause();
                if (patt1$temp instanceof ParserException) {
                    ParserException parserException = (ParserException)patt1$temp;
                    msg = (Component)parserException.formatCaption(captionFormatter);
                } else {
                    msg = Component.literal((String)((ArgumentParseException)exceptionContext.exception()).getCause().getMessage());
                }
            }
            sendError.accept(source, (Component)exceptionContext.context().formatCaption(captionFormatter, StandardCaptionKeys.EXCEPTION_INVALID_ARGUMENT, MinecraftVariable.of("cause", (Component)Component.literal((String)"").append(ComponentUtils.fromMessage((Message)msg)).withStyle(ChatFormatting.GRAY))));
        });
        ctx.registerHandler(NoSuchCommandException.class, (source, exceptionContext) -> sendError.accept(source, (Component)exceptionContext.context().formatCaption(captionFormatter, StandardCaptionKeys.EXCEPTION_NO_SUCH_COMMAND, new CaptionVariable[0])));
        ctx.registerHandler(NoPermissionException.class, (source, exceptionContext) -> sendError.accept(source, (Component)exceptionContext.context().formatCaption(captionFormatter, StandardCaptionKeys.EXCEPTION_NO_PERMISSION, new CaptionVariable[0])));
        ctx.registerHandler(InvalidCommandSenderException.class, (source, exceptionContext) -> {
            boolean multiple = ((InvalidCommandSenderException)exceptionContext.exception()).requiredSenderTypes().size() > 1;
            String expected = multiple ? ((InvalidCommandSenderException)exceptionContext.exception()).requiredSenderTypes().stream().map(TypeUtils::simpleName).collect(Collectors.joining(", ")) : TypeUtils.simpleName(((InvalidCommandSenderException)exceptionContext.exception()).requiredSenderTypes().iterator().next());
            sendError.accept(source, (Component)exceptionContext.context().formatCaption(captionFormatter, multiple ? StandardCaptionKeys.EXCEPTION_INVALID_SENDER_LIST : StandardCaptionKeys.EXCEPTION_INVALID_SENDER, CaptionVariable.of("actual", exceptionContext.context().sender().getClass().getSimpleName()), CaptionVariable.of("expected", expected)));
        });
        ctx.registerHandler(InvalidSyntaxException.class, (source, exceptionContext) -> sendError.accept(source, (Component)exceptionContext.context().formatCaption(captionFormatter, StandardCaptionKeys.EXCEPTION_INVALID_SYNTAX, MinecraftVariable.of("syntax", (Component)Component.literal((String)String.format("/%s", ((InvalidSyntaxException)exceptionContext.exception()).correctSyntax())).withStyle(style -> style.withColor(ChatFormatting.GRAY))))));
    }

    private static <C> Component decorateHoverStacktrace(CommandManager<C> manager, Component input, Throwable cause, C sender) {
        if (!manager.hasPermission(sender, "cloud.hover-stacktrace")) {
            return input;
        }
        MutableComponent result = input.copy();
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replace("\t", "    ");
        return result.withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)stackTrace).append(NEWLINE).append((Component)Component.literal((String)"    Click to copy").withStyle(s2 -> s2.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))))).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(stackTrace)));
    }

    @API(status=API.Status.INTERNAL)
    public record RegisterContext<C, S extends SharedSuggestionProvider>(CommandManager<C> manager) {
        private <T extends Throwable> void registerHandler(Class<T> exceptionType, ModdedExceptionHandler<C, S, T> handler) {
            this.manager.exceptionController().registerHandler(exceptionType, handler);
        }
    }
}

