/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.parser;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.sponge.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.exception.parsing.ParserException;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.ModdedCommandContextKeys;
import org.empirewar.orbis.sponge.libs.cloud.minecraft.modded.caption.ModdedCaptionKeys;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserDescriptor;
import org.empirewar.orbis.sponge.libs.cloud.suggestion.BlockingSuggestionProvider;

public final class RegistryEntryParser<C, V>
implements ArgumentParser<C, V>,
BlockingSuggestionProvider.Strings<C> {
    private static final String NAMESPACE_MINECRAFT = "minecraft";
    private final ResourceKey<? extends Registry<V>> registryIdent;

    public static <C, V> @NonNull ParserDescriptor<C, V> registryEntryParser(@NonNull ResourceKey<? extends Registry<V>> registry, @NonNull TypeToken<V> valueType) {
        return ParserDescriptor.of(new RegistryEntryParser<C, V>(registry), valueType);
    }

    public static <C, V> @NonNull ParserDescriptor<C, V> registryEntryParser(@NonNull ResourceKey<? extends Registry<V>> registry, @NonNull Class<V> valueType) {
        return ParserDescriptor.of(new RegistryEntryParser<C, V>(registry), TypeToken.get(valueType));
    }

    public static <C, V> @NonNull CommandComponent.Builder<C, V> registryEntryComponent(@NonNull ResourceKey<? extends Registry<V>> registry, @NonNull TypeToken<V> valueType) {
        return CommandComponent.builder().parser(RegistryEntryParser.registryEntryParser(registry, valueType));
    }

    public RegistryEntryParser(@NonNull ResourceKey<? extends Registry<V>> registry) {
        this.registryIdent = registry;
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull V> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        ResourceLocation key;
        try {
            key = ResourceLocation.read((StringReader)new StringReader(commandInput.readString()));
        }
        catch (CommandSyntaxException ex) {
            return ArgumentParseResult.failure(ex);
        }
        Registry<V> registry = this.resolveRegistry(commandContext);
        if (registry == null) {
            return ArgumentParseResult.failure(new IllegalArgumentException("Unknown registry " + String.valueOf(this.registryIdent)));
        }
        Object entry = registry.getValue(key);
        if (entry == null) {
            return ArgumentParseResult.failure(new UnknownEntryException(commandContext, key, this.registryIdent));
        }
        return ArgumentParseResult.success(entry);
    }

    private Registry<V> resolveRegistry(CommandContext<C> ctx) {
        SharedSuggestionProvider reverseMapped = ctx.get(ModdedCommandContextKeys.SHARED_SUGGESTION_PROVIDER);
        return reverseMapped.registryAccess().lookup(this.registryIdent).orElse(null);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        Set ids = this.resolveRegistry(commandContext).keySet();
        ArrayList<String> results = new ArrayList<String>(ids.size());
        for (ResourceLocation entry : ids) {
            if (entry.getNamespace().equals(NAMESPACE_MINECRAFT)) {
                results.add(entry.getPath());
            }
            results.add(entry.toString());
        }
        return results;
    }

    public ResourceKey<? extends Registry<?>> registryKey() {
        return this.registryIdent;
    }

    private static final class UnknownEntryException
    extends ParserException {
        UnknownEntryException(CommandContext<?> context, ResourceLocation key, ResourceKey<? extends Registry<?>> registry) {
            super(RegistryEntryParser.class, context, ModdedCaptionKeys.ARGUMENT_PARSE_FAILURE_REGISTRY_ENTRY_UNKNOWN_ENTRY, CaptionVariable.of("id", key.toString()), CaptionVariable.of("registry", registry.toString()));
        }
    }
}

