/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.parser.standard;

import org.apiguardian.api.API;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandContext;
import org.empirewar.orbis.sponge.libs.cloud.context.CommandInput;
import org.empirewar.orbis.sponge.libs.cloud.exception.parsing.NumberParseException;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.sponge.libs.cloud.parser.ParserDescriptor;
import org.empirewar.orbis.sponge.libs.cloud.parser.standard.NumberParser;
import org.empirewar.orbis.sponge.libs.cloud.type.range.DoubleRange;
import org.empirewar.orbis.sponge.libs.cloud.type.range.Range;

@API(status=API.Status.STABLE)
public final class DoubleParser<C>
extends NumberParser<C, Double, DoubleRange> {
    @API(status=API.Status.STABLE)
    public static final double DEFAULT_MINIMUM = Double.NEGATIVE_INFINITY;
    @API(status=API.Status.STABLE)
    public static final double DEFAULT_MAXIMUM = Double.POSITIVE_INFINITY;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Double> doubleParser() {
        return DoubleParser.doubleParser(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Double> doubleParser(double minValue) {
        return ParserDescriptor.of(new DoubleParser<C>(minValue, Double.POSITIVE_INFINITY), Double.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Double> doubleParser(double minValue, double maxValue) {
        return ParserDescriptor.of(new DoubleParser<C>(minValue, maxValue), Double.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Double> doubleComponent() {
        return CommandComponent.builder().parser(DoubleParser.doubleParser());
    }

    public DoubleParser(double min2, double max) {
        super(Range.doubleRange(min2, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Double> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidDouble((DoubleRange)this.range())) {
            return ArgumentParseResult.failure(new DoubleParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readDouble());
    }

    @Override
    public boolean hasMax() {
        return ((DoubleRange)this.range()).maxDouble() != Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean hasMin() {
        return ((DoubleRange)this.range()).minDouble() != Double.NEGATIVE_INFINITY;
    }

    @API(status=API.Status.STABLE)
    public static final class DoubleParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public DoubleParseException(@NonNull String input, @NonNull DoubleParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "double";
        }
    }
}

