/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.sponge;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.SenderMapper;
import org.empirewar.orbis.sponge.libs.cloud.execution.ExecutionCoordinator;
import org.spongepowered.api.command.CommandCause;

public final class CloudInjectionModule<C>
extends AbstractModule {
    private final Class<C> commandSenderType;
    private final ExecutionCoordinator<C> executionCoordinator;
    private final SenderMapper<@NonNull CommandCause, @NonNull C> senderMapper;

    public CloudInjectionModule(@NonNull Class<C> commandSenderType, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SenderMapper<@NonNull CommandCause, @NonNull C> senderMapper) {
        this.commandSenderType = commandSenderType;
        this.executionCoordinator = executionCoordinator;
        this.senderMapper = senderMapper;
    }

    public static @NonNull CloudInjectionModule<@NonNull CommandCause> createNative(@NonNull ExecutionCoordinator<CommandCause> executionCoordinator) {
        return new CloudInjectionModule<CommandCause>(CommandCause.class, executionCoordinator, SenderMapper.identity());
    }

    protected void configure() {
        ParameterizedType commandExecutionCoordinatorType = Types.newParameterizedType(ExecutionCoordinator.class, (Type[])new Type[]{this.commandSenderType});
        Key coordinatorKey = Key.get((Type)commandExecutionCoordinatorType);
        this.bind(coordinatorKey).toInstance(this.executionCoordinator);
        ParameterizedType commandSenderMapperFunction = Types.newParameterizedType(SenderMapper.class, (Type[])new Type[]{CommandCause.class, this.commandSenderType});
        Key senderMapperKey = Key.get((Type)commandSenderMapperFunction);
        this.bind(senderMapperKey).toInstance(this.senderMapper);
    }
}

