/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.cloud.sponge;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.empirewar.orbis.sponge.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.sponge.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.sponge.libs.cloud.internal.CommandNode;
import org.empirewar.orbis.sponge.libs.cloud.parser.ArgumentParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.aggregate.AggregateParser;
import org.empirewar.orbis.sponge.libs.cloud.parser.standard.LiteralParser;
import org.empirewar.orbis.sponge.libs.cloud.permission.Permission;
import org.empirewar.orbis.sponge.libs.cloud.sponge.SpongeCommandManager;
import org.empirewar.orbis.sponge.libs.cloud.type.tuple.Pair;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.api.registry.RegistryHolder;

final class CloudSpongeCommand<C>
implements Command.Raw {
    private final SpongeCommandManager<C> commandManager;
    private final String label;

    CloudSpongeCommand(@NonNull String label, @NonNull SpongeCommandManager<C> commandManager) {
        this.label = label;
        this.commandManager = commandManager;
    }

    public CommandResult process(@NonNull CommandCause cause, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ArgumentReader.Mutable arguments) {
        C cloudSender = this.commandManager.senderMapper().map(cause);
        String input = this.formatCommandForParsing(arguments.input());
        this.commandManager.commandExecutor().executeCommand(cloudSender, input);
        return CommandResult.success();
    }

    public List<CommandCompletion> complete(@NonNull CommandCause cause, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ArgumentReader.Mutable arguments) {
        return this.commandManager.suggestionFactory().suggestImmediately(this.commandManager.senderMapper().map(cause), this.formatCommandForSuggestions(arguments.input())).list().stream().map(s2 -> CommandCompletion.of((String)s2.suggestion(), (Component)s2.tooltip())).collect(Collectors.toList());
    }

    public boolean canExecute(@NonNull CommandCause cause) {
        return this.checkAccess(cause, this.namedNode().nodeMeta().getOrDefault(CommandNode.META_KEY_ACCESS, Collections.emptyMap()));
    }

    public Optional<Component> shortDescription(CommandCause cause) {
        return Optional.of(this.usage(cause));
    }

    public Optional<Component> extendedDescription(CommandCause cause) {
        return Optional.of(this.usage(cause));
    }

    public Optional<Component> help(@NonNull CommandCause cause) {
        return Optional.of(this.usage(cause));
    }

    public Component usage(CommandCause cause) {
        return Component.text((String)this.commandManager.commandSyntaxFormatter().apply(this.commandManager.senderMapper().map(cause), Collections.emptyList(), this.namedNode()));
    }

    private CommandNode<C> namedNode() {
        return this.commandManager.commandTree().getNamedNode(this.label);
    }

    public CommandTreeNode.Root commandTree(RegistryHolder registryHolder) {
        CommandTreeNode root = CommandTreeNode.root();
        CommandNode<C> cloud = this.namedNode();
        if (CloudSpongeCommand.canExecute(cloud)) {
            root.executable();
        }
        this.addRequirement(cloud, root);
        this.addChildren(registryHolder, root, cloud);
        return (CommandTreeNode.Root)root;
    }

    private void addChildren(RegistryHolder registryHolder, CommandTreeNode<?> node, CommandNode<C> cloud) {
        for (CommandNode<C> child : cloud.children()) {
            CommandTreeNode.Argument<CommandTreeNode.Argument<?>> treeNode;
            CommandComponent<C> value = child.component();
            if (value.parser() instanceof LiteralParser) {
                treeNode = (CommandTreeNode.Argument<CommandTreeNode.Argument<?>>)CommandTreeNode.literal();
            } else {
                ArgumentParser<C, ?> argumentParser = value.parser();
                if (argumentParser instanceof AggregateParser) {
                    AggregateParser aggregate = (AggregateParser)argumentParser;
                    this.handleAggregate(registryHolder, node, child, aggregate);
                    continue;
                }
                treeNode = this.commandManager.parserMapper().mapComponent(registryHolder, value);
            }
            this.addRequirement(child, (CommandTreeNode<? extends CommandTreeNode<?>>)treeNode);
            if (CloudSpongeCommand.canExecute(child)) {
                treeNode.executable();
            }
            this.addChildren(registryHolder, (CommandTreeNode<?>)treeNode, child);
            node.child(value.name(), treeNode);
        }
    }

    private void handleAggregate(RegistryHolder registryHolder, CommandTreeNode<?> node, CommandNode<C> child, AggregateParser<C, ?> compound) {
        ArrayDeque nodes = new ArrayDeque();
        for (CommandComponent<C> component : compound.components()) {
            String name = component.name();
            nodes.add(Pair.of(name, this.commandManager.parserMapper().mapParser(registryHolder, component.parser())));
        }
        Pair argument = null;
        while (!nodes.isEmpty()) {
            Pair prev = argument;
            argument = (Pair)nodes.removeLast();
            if (prev != null) {
                ((CommandTreeNode.Argument)argument.second()).child((String)prev.first(), (CommandTreeNode.Argument)prev.second());
            } else if (CloudSpongeCommand.canExecute(child)) {
                ((CommandTreeNode.Argument)argument.second()).executable();
            }
            this.addRequirement(child, (CommandTreeNode)argument.second());
        }
        CommandTreeNode.Argument treeNode = (CommandTreeNode.Argument)argument.second();
        this.addChildren(registryHolder, (CommandTreeNode<?>)treeNode, child);
        node.child(compound.components().get(0).toString(), treeNode);
    }

    private static <C> boolean canExecute(@NonNull CommandNode<C> node) {
        return node.isLeaf() || !node.component().required() || node.command() != null || node.children().stream().noneMatch(c -> c.component().required());
    }

    private void addRequirement(@NonNull CommandNode<C> cloud, @NonNull CommandTreeNode<? extends CommandTreeNode<?>> node) {
        Map accessMap = cloud.nodeMeta().getOrDefault(CommandNode.META_KEY_ACCESS, Collections.emptyMap());
        node.requires(cause -> this.checkAccess((CommandCause)cause, accessMap));
    }

    private boolean checkAccess(CommandCause cause, Map<Type, Permission> accessMap) {
        C cloudSender = this.commandManager.senderMapper().map(cause);
        for (Map.Entry<Type, Permission> entry : accessMap.entrySet()) {
            if (!GenericTypeReflector.isSuperType((Type)entry.getKey(), cloudSender.getClass()) || !this.commandManager.testPermission(cloudSender, entry.getValue()).allowed()) continue;
            return true;
        }
        return false;
    }

    private String formatCommandForParsing(@NonNull String arguments) {
        if (arguments.isEmpty()) {
            return this.label;
        }
        return this.label + " " + arguments;
    }

    private String formatCommandForSuggestions(@NonNull String arguments) {
        return this.label + " " + arguments;
    }
}

