/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.rtree.geometry.internal;

import org.empirewar.orbis.sponge.libs.rtree.geometry.Rectangle;

public final class GeometryUtil {
    private GeometryUtil() {
    }

    public static double max(double a, double b) {
        if (a < b) {
            return b;
        }
        return a;
    }

    public static double distance(double[] x, Rectangle r) {
        return GeometryUtil.distance(x, r.mins(), r.maxes());
    }

    public static double distance(double[] x, double[] a, double[] b) {
        return GeometryUtil.distance(x, x, a, b);
    }

    public static double distance(double[] x, double[] y, double[] a, double[] b) {
        if (GeometryUtil.intersects(x, y, a, b)) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            boolean xyMostLeft = x[i] < a[i];
            double mostLeftX1 = xyMostLeft ? x[i] : a[i];
            double mostRightX1 = xyMostLeft ? a[i] : x[i];
            double mostLeftX2 = xyMostLeft ? y[i] : b[i];
            double xDifference = GeometryUtil.max(0.0, mostLeftX1 == mostRightX1 ? 0.0 : mostRightX1 - mostLeftX2);
            sum += xDifference * xDifference;
        }
        return Math.sqrt(sum);
    }

    public static boolean intersects(double[] mins, double[] maxes, double[] minsOther, double[] maxesOther) {
        for (int i = 0; i < mins.length; ++i) {
            if (!(mins[i] > maxesOther[i]) && !(maxes[i] < minsOther[i])) continue;
            return false;
        }
        return true;
    }

    public static double[] min(double[] a, double[] b) {
        double[] p = new double[a.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = Math.min(a[i], b[i]);
        }
        return p;
    }

    public static double[] max(double[] a, double[] b) {
        double[] p = new double[a.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = Math.max(a[i], b[i]);
        }
        return p;
    }
}

