/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.libs.rtree.internal;

import java.util.List;
import org.empirewar.orbis.sponge.libs.rtree.Context;
import org.empirewar.orbis.sponge.libs.rtree.Entry;
import org.empirewar.orbis.sponge.libs.rtree.Node;
import org.empirewar.orbis.sponge.libs.rtree.NonLeaf;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Geometry;
import org.empirewar.orbis.sponge.libs.rtree.geometry.Rectangle;
import org.empirewar.orbis.sponge.libs.rtree.guava.Preconditions;
import org.empirewar.orbis.sponge.libs.rtree.internal.NodeAndEntries;
import org.empirewar.orbis.sponge.libs.rtree.internal.NonLeafHelper;
import org.empirewar.orbis.sponge.libs.rtree.internal.Util;

public final class NonLeafDefault<T, S extends Geometry>
implements NonLeaf<T, S> {
    private final List<? extends Node<T, S>> children;
    private final Rectangle mbr;
    private final Context<T, S> context;

    public NonLeafDefault(List<? extends Node<T, S>> children, Context<T, S> context) {
        Preconditions.checkArgument(!children.isEmpty());
        this.context = context;
        this.children = children;
        this.mbr = Util.mbr(children);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    @Override
    public int count() {
        return this.children.size();
    }

    @Override
    public List<Node<T, S>> add(Entry<? extends T, ? extends S> entry) {
        return NonLeafHelper.add(entry, this);
    }

    @Override
    public NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        return NonLeafHelper.delete(entry, all, this);
    }

    @Override
    public Context<T, S> context() {
        return this.context;
    }

    @Override
    public Node<T, S> child(int i) {
        return this.children.get(i);
    }

    @Override
    public List<Node<T, S>> children() {
        return this.children;
    }

    public String toString() {
        return "NonLeafDefault [mbr=" + this.mbr + ", children=" + this.children + "]";
    }
}

