/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.sponge.listener;

import java.util.List;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.block.transaction.Operations;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.tag.BlockTypeTags;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3i;

public final class BlockActionListener {
    private final Orbis orbis;

    public BlockActionListener(Orbis orbis) {
        this.orbis = orbis;
    }

    @Listener(order=Order.EARLY)
    public void onChange(ChangeBlockEvent.All event, @First ServerPlayer serverPlayer) {
        event.transactions((Operation)Operations.BREAK.get()).forEach(transaction -> {
            if (this.shouldPreventBlockAction((BlockSnapshot)transaction.original(), serverPlayer, DefaultFlags.CAN_BREAK)) {
                event.invalidateAll();
            }
        });
        event.transactions((Operation)Operations.PLACE.get()).forEach(transaction -> {
            if (this.shouldPreventBlockAction((BlockSnapshot)transaction.original(), serverPlayer, DefaultFlags.CAN_PLACE)) {
                event.invalidateAll();
            }
        });
        event.transactions((Operation)Operations.DECAY.get()).forEach(transaction -> {
            if (this.shouldPreventBlockAction((BlockSnapshot)transaction.original(), DefaultFlags.LEAF_DECAY)) {
                transaction.invalidate();
            }
        });
        event.transactions((Operation)Operations.GROWTH.get()).forEach(transaction -> {
            BlockSnapshot block = (BlockSnapshot)transaction.finalReplacement();
            RegionisedWorld world = this.orbis.getRegionisedWorld((Key)event.world().key());
            List growable = world.query(RegionQuery.Position.builder().position(block.position().x(), block.position().y(), block.position().z())).query(RegionQuery.Flag.builder(DefaultFlags.GROWABLE_BLOCKS)).result().orElse(null);
            if (growable == null) {
                return;
            }
            if (!growable.contains(block.state().type().key(RegistryTypes.BLOCK_TYPE))) {
                transaction.invalidate();
            }
        });
        event.transactions((Operation)Operations.MODIFY.get()).forEach(transaction -> {
            BlockSnapshot original = (BlockSnapshot)transaction.original();
            BlockSnapshot replacement = (BlockSnapshot)transaction.finalReplacement();
            if ((original.state().type().isAnyOf(new BlockType[]{(BlockType)BlockTypes.FARMLAND.get()}) && replacement.state().type().isAnyOf(new BlockType[]{(BlockType)BlockTypes.DIRT.get()}) || original.state().type().isAnyOf(new BlockType[]{(BlockType)BlockTypes.TURTLE_EGG.get()})) && this.shouldPreventBlockAction(original, serverPlayer, DefaultFlags.BLOCK_TRAMPLE)) {
                transaction.invalidate();
            }
            if (!original.state().type().is(BlockTypeTags.CORALS)) {
                return;
            }
            if (replacement.state().type().key(RegistryTypes.BLOCK_TYPE).asString().contains("DEAD") && this.shouldPreventBlockAction(original, DefaultFlags.CORAL_DECAY)) {
                transaction.invalidate();
            }
        });
    }

    @Listener(order=Order.EARLY)
    public void onFireSpread(ChangeBlockEvent.Pre event) {
        if (!event.context().containsKey(EventContextKeys.FIRE_SPREAD)) {
            return;
        }
        for (ServerLocation location : event.locations()) {
            if (!this.shouldPreventBlockAction(location.createSnapshot(), DefaultFlags.FIRE_SPREAD)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @Listener(order=Order.EARLY)
    public void onAttemptAccess(InteractContainerEvent.Open event) {
    }

    @Listener(order=Order.EARLY)
    public void onRedstoneUse(InteractBlockEvent.Secondary.Pre event, @Root ServerPlayer player) {
        BlockSnapshot block = event.block();
        if ((block.get(Keys.POWER).isPresent() || block.get(Keys.IS_POWERED).isPresent() || block.get(Keys.REDSTONE_DELAY).isPresent()) && this.shouldPreventBlockAction(block, player, DefaultFlags.TRIGGER_REDSTONE)) {
            event.setUseBlockResult(Tristate.FALSE);
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.EARLY)
    public void onPistonPushPull(ChangeBlockEvent.Pre event) {
        if (!event.context().containsKey(EventContextKeys.PISTON_EXTEND) && !event.context().containsKey(EventContextKeys.PISTON_RETRACT)) {
            return;
        }
        event.locations().forEach(location -> {
            if (this.shouldPreventBlockAction(location.createSnapshot(), DefaultFlags.ACTIVATE_PISTONS)) {
                event.setCancelled(true);
            }
        });
    }

    private boolean shouldPreventBlockAction(@Nullable BlockSnapshot block, RegistryRegionFlag<Boolean> flag) {
        return this.shouldPreventBlockAction(block, null, flag);
    }

    private boolean shouldPreventBlockAction(@Nullable BlockSnapshot block, @Nullable ServerPlayer player, RegistryRegionFlag<Boolean> flag) {
        boolean canAct;
        if (block == null) {
            return false;
        }
        Vector3i blockPos = block.position();
        Vector3d pos = new Vector3d((double)blockPos.x(), (double)blockPos.y(), (double)blockPos.z());
        RegionisedWorld world = this.orbis.getRegionisedWorld((Key)((ServerWorld)((ServerLocation)block.location().orElseThrow()).world()).key());
        RegionQuery.Flag.Builder<Boolean> builder = RegionQuery.Flag.builder(flag);
        if (player != null) {
            builder.player(player.uniqueId());
        }
        return !(canAct = world.query(RegionQuery.Position.builder().position((Vector3dc)pos)).query(builder).result().orElse(true).booleanValue());
    }
}

