/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.exception.IncompleteAreaException;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.world.RegionisedWorld;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;

public abstract class RegionVisualiserTaskBase
implements Runnable {
    protected final OrbisPlatform platform;
    private final Map<UUID, CachedArea> areaCache = new HashMap<UUID, CachedArea>();
    private static final double MAX_DISTANCE_SQUARED = 16384.0;

    public RegionVisualiserTaskBase(OrbisPlatform platform) {
        this.platform = platform;
    }

    @Override
    public void run() {
        HashSet<UUID> currentPlayers = new HashSet<UUID>(this.platform.getVisualisingPlayers());
        Set<UUID> playersToRemove = this.areaCache.keySet().stream().filter(uuid -> !currentPlayers.contains(uuid)).collect(Collectors.toSet());
        playersToRemove.forEach(this.areaCache::remove);
        for (UUID player : currentPlayers) {
            this.showSelection(player);
            this.showCurrentPrioritisedRegionArea(player);
        }
    }

    private void showCurrentPrioritisedRegionArea(UUID player) {
        Vector3dc position;
        Key playerWorld = this.platform.getPlayerWorld(player);
        RegionisedWorld regionisedWorld = this.platform.getRegionisedWorld(playerWorld);
        Optional region = ((Set)regionisedWorld.query(RegionQuery.Position.at(position = this.getPlayerPosition(player))).result()).stream().findFirst();
        if (region.isEmpty() || ((Region)region.get()).isGlobal()) {
            return;
        }
        Area area = ((Region)region.get()).area();
        this.showParticlesForArea(area, player, this::showGreenParticle);
    }

    private void showSelection(UUID player) {
        Selection selection = this.platform.selectionManager().get(player).orElse(null);
        if (selection == null) {
            this.areaCache.remove(player);
            return;
        }
        try {
            int currentHash = Objects.hash(selection.getPoints().toArray());
            CachedArea cached = this.areaCache.get(player);
            if (cached == null || cached.pointsHash != currentHash) {
                Area area = selection.build();
                this.areaCache.put(player, new CachedArea(area, currentHash));
                this.showParticlesForArea(area, player, this::showOrangeParticle);
            } else {
                this.showParticlesForArea(cached.area, player, this::showOrangeParticle);
            }
        }
        catch (IncompleteAreaException ignored) {
            this.areaCache.remove(player);
        }
    }

    private void showParticlesForArea(Area area, UUID player, BiConsumer<UUID, Vector3dc> particle) {
        Vector3dc playerPos = this.getPlayerPosition(player);
        Set<Vector3ic> boundary = area.getBoundaryPoints();
        for (Vector3ic point : boundary) {
            Vector3d particlePos = new Vector3d((double)point.x() + 0.5, (double)point.y() + 0.5, (double)point.z() + 0.5);
            if (!(playerPos.distanceSquared((Vector3dc)particlePos) <= 16384.0)) continue;
            particle.accept(player, (Vector3dc)particlePos);
        }
    }

    protected abstract Vector3dc getPlayerPosition(UUID var1);

    protected abstract void showGreenParticle(UUID var1, Vector3dc var2);

    protected abstract void showOrangeParticle(UUID var1, Vector3dc var2);

    private record CachedArea(Area area, int pointsHash) {
    }
}

