/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslationStore;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.command.caption.OrbisCaptionProvider;
import org.empirewar.orbis.region.GlobalRegion;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.registry.lifecycle.RegistryLifecycles;
import org.empirewar.orbis.selection.SelectionManager;
import org.empirewar.orbis.serialization.StaticGsonProvider;
import org.empirewar.orbis.world.RegionisedWorld;
import org.empirewar.orbis.world.RegionisedWorldSet;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public abstract class OrbisPlatform
implements Orbis {
    private static final String GLOBAL_REGION_ID = "orbis:global";
    private final SelectionManager selectionManager = new SelectionManager();
    private final Map<Key, RegionisedWorldSet> worldSets = new ConcurrentHashMap<Key, RegionisedWorldSet>();
    private final Set<UUID> visualisingPlayers = ConcurrentHashMap.newKeySet();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private ConfigurationLoader<CommentedConfigurationNode> loaderRoot;
    private ConfigurationLoader<CommentedConfigurationNode> loaderWorlds;
    private ConfigurationNode rootNode;
    private ConfigurationNode worldsNode;

    public MiniMessage miniMessage() {
        return this.miniMessage;
    }

    public OrbisPlatform() {
        OrbisAPI.set(this);
    }

    protected void load() {
        try {
            this.loadConfigs();
        }
        catch (IOException e) {
            this.logger().error("Error loading configs", (Throwable)e);
        }
        MiniMessageTranslationStore store = MiniMessageTranslationStore.create((Key)Key.key((String)"orbis", (String)"translations"));
        store.defaultLocale(Locale.UK);
        File translationsDirectory = this.dataFolder().resolve("translations").toFile();
        translationsDirectory.mkdirs();
        Locale.availableLocales().forEach(locale -> {
            String resourcePath = String.format("assets/orbis/translations_%s.properties", locale.toString());
            if (OrbisPlatform.class.getClassLoader().getResource(resourcePath) != null) {
                try {
                    Path target = translationsDirectory.toPath().resolve(String.format("%s.properties", locale));
                    try (InputStream is = this.getResourceAsStream("/" + resourcePath);){
                        try {
                            Files.copy(is, target, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException ignored) {
                            this.compareTranslations((Locale)locale, resourcePath, target);
                        }
                    }
                    store.registerAll(locale, target, true);
                    this.logger().info("Loaded translations for {}", locale);
                }
                catch (Exception e) {
                    this.logger().warn("Failed to copy translations for {}", locale, (Object)e);
                }
            }
        });
        GlobalTranslator.translator().addSource((Translator)store);
        OrbisCaptionProvider.registerTranslations();
    }

    private void compareTranslations(Locale locale, String resourcePath, Path target) {
        try (InputStream existingIn = Files.newInputStream(target, new OpenOption[0]);
             InputStream jarIn = this.getResourceAsStream("/" + resourcePath);){
            if (jarIn != null) {
                Properties existingProps = new Properties();
                Properties jarProps = new Properties();
                existingProps.load(existingIn);
                jarProps.load(jarIn);
                Set<String> existingKeys = existingProps.stringPropertyNames();
                Set<String> jarKeys = jarProps.stringPropertyNames();
                Set missingKeys = jarKeys.stream().filter(k -> !existingKeys.contains(k)).collect(Collectors.toSet());
                Set extraKeys = existingKeys.stream().filter(k -> !jarKeys.contains(k)).collect(Collectors.toSet());
                if (!missingKeys.isEmpty()) {
                    this.logger().warn("Translations for {} are missing keys: {}", (Object)locale, missingKeys);
                }
                if (!extraKeys.isEmpty()) {
                    this.logger().warn("Translations for {} contain unknown/removed keys: {}", (Object)locale, extraKeys);
                }
                if (!missingKeys.isEmpty() || !extraKeys.isEmpty()) {
                    this.logger().warn("Consider regenerating the translation file for {}", (Object)locale);
                }
            }
        }
        catch (IOException e) {
            this.logger().warn("Failed to compare translation keys for {}", (Object)locale, (Object)e);
        }
    }

    protected abstract InputStream getResourceAsStream(String var1);

    private void loadConfigs() throws IOException {
        File dataFolderFile = this.dataFolder().toFile();
        if (!dataFolderFile.exists()) {
            dataFolderFile.mkdirs();
        }
        Path configPath = this.dataFolder().resolve("config.yml");
        Path worldsPath = this.dataFolder().resolve("worlds.yml");
        if (!Files.exists(worldsPath, new LinkOption[0])) {
            if (Files.exists(configPath, new LinkOption[0])) {
                Files.copy(configPath, worldsPath, new CopyOption[0]);
            } else {
                Files.createFile(worldsPath, new FileAttribute[0]);
            }
        }
        this.loaderWorlds = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(worldsPath)).build();
        this.worldsNode = this.loaderWorlds.load();
        try {
            Files.copy(this.getResourceAsStream("/assets/orbis/config.yml"), configPath, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.loaderRoot = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).build();
        this.rootNode = this.loaderRoot.load();
    }

    @Override
    public ConfigurationNode config() {
        return this.rootNode;
    }

    @Override
    public ConfigurationNode worldsConfig() {
        return this.worldsNode;
    }

    public void loadWorld(Key world, UUID worldId) {
        try {
            ArrayList regionNames = new ArrayList();
            ConfigurationNode worldsNode = this.worldsConfig().node(new Object[]{"worlds"});
            for (Object configWorldName : worldsNode.childrenMap().keySet()) {
                String stringConfigWorldName = (String)configWorldName;
                if (!world.asString().matches(stringConfigWorldName)) continue;
                regionNames.addAll(worldsNode.node(new Object[]{stringConfigWorldName, "regions"}).getList(String.class, new ArrayList()));
            }
            RegionisedWorldSet set = new RegionisedWorldSet(world);
            String worldKeyName = set.worldId().orElseThrow().asString();
            ArrayList<Region> regions = new ArrayList<Region>(regionNames.size());
            Region globalSetRegion = OrbisRegistries.REGIONS.get(worldKeyName).orElseGet(() -> OrbisRegistries.REGIONS.register(worldKeyName, (Region)new GlobalRegion(set)));
            for (String regionName : regionNames) {
                if (regionName.equals(worldKeyName)) {
                    this.logger().error("Illegal region name in world set");
                    continue;
                }
                Region region = OrbisRegistries.REGIONS.get(regionName).orElse(null);
                if (region == null) {
                    this.logger().warn("Region by name '{}' could not be found, ignoring...", (Object)regionName);
                    continue;
                }
                regions.add(region);
            }
            set.add(globalSetRegion);
            set.add((Region)OrbisRegistries.REGIONS.get(GLOBAL_REGION_ID).orElseThrow());
            regions.forEach(set::add);
            this.worldSets.put(world, set);
            this.logger().info("Loaded world set {} ({}) with {} regions", new Object[]{worldId, world.asMinimalString(), regions.size()});
        }
        catch (SerializationException e) {
            this.logger().error("Error loading world set {} ({})", new Object[]{worldId, world.asMinimalString(), e});
        }
    }

    public void loadRegions() throws IOException {
        File regionsFolder;
        if (!this.isTestEnvironment() || OrbisRegistries.FLAGS.getLifecycle() != RegistryLifecycles.frozen()) {
            OrbisRegistries.FLAGS.setLifecycle(RegistryLifecycles.frozen());
        }
        if (!(regionsFolder = this.dataFolder().resolve("regions").toFile()).exists()) {
            regionsFolder.mkdirs();
        }
        for (File regionFile : regionsFolder.listFiles()) {
            if (!regionFile.getName().endsWith(".json")) continue;
            try (FileReader reader = new FileReader(regionFile);){
                Region region = (Region)StaticGsonProvider.GSON.fromJson((Reader)reader, Region.class);
                if (region == null) {
                    this.logger().error("Error loading region from '{}' - is the file corrupted?", (Object)regionFile);
                    continue;
                }
                OrbisRegistries.REGIONS.register(region.name(), region);
            }
        }
        boolean hasGlobalRegion = OrbisRegistries.REGIONS.get(GLOBAL_REGION_ID).isPresent();
        if (!hasGlobalRegion) {
            GlobalRegion globalRegion = new GlobalRegion(GLOBAL_REGION_ID);
            globalRegion.priority(0);
            OrbisRegistries.REGIONS.register(GLOBAL_REGION_ID, (Region)globalRegion);
        }
        if (!this.isTestEnvironment() || OrbisRegistries.REGIONS.getLifecycle() != RegistryLifecycles.active()) {
            OrbisRegistries.REGIONS.setLifecycle(RegistryLifecycles.active());
        }
    }

    public void saveRegions() throws IOException {
        File regionsFolder = this.dataFolder().resolve("regions").toFile();
        if (!regionsFolder.exists()) {
            regionsFolder.mkdirs();
        }
        for (Region region : OrbisRegistries.REGIONS.getAll()) {
            File regionFile = new File(String.valueOf(regionsFolder) + File.separator + region.name().replace(":", "-") + ".json");
            try (FileWriter writer = new FileWriter(regionFile);){
                StaticGsonProvider.GSON.toJson((Object)region, (Appendable)writer);
            }
        }
        for (RegionisedWorld world : this.getRegionisedWorlds()) {
            this.saveWorldSet(world);
        }
    }

    public void saveWorld(Key world, UUID worldId) {
        RegionisedWorldSet removed = this.worldSets.remove(world);
        if (removed == null) {
            this.logger().warn("Unable to save world set {} ({}) because it could not be found", (Object)worldId, (Object)world.asMinimalString());
            return;
        }
        try {
            this.saveWorldSet(removed);
        }
        catch (IOException e) {
            this.logger().error("Error saving world set {} ({})", new Object[]{worldId, world.key().asMinimalString(), e});
        }
    }

    private void saveWorldSet(RegionisedWorld world) throws IOException {
        world.worldId().ifPresent(id -> this.logger().info("Saving world {}", id));
        ConfigurationNode node = this.worldsConfig().node(new Object[]{"worlds", world.worldId().orElseThrow().asString(), "regions"});
        ArrayList<String> regionsInWorld = new ArrayList<String>();
        for (Region region : world.regions()) {
            if (region.name().equals(world.worldId().orElseThrow().asString())) continue;
            regionsInWorld.add(region.name());
        }
        node.setList(String.class, regionsInWorld);
        try {
            this.loaderWorlds.save(this.worldsConfig());
        }
        catch (ConfigurateException e) {
            this.logger().error("Error saving worlds", (Throwable)e);
        }
    }

    @Override
    public boolean removeRegion(Region region) {
        boolean anySucceeded = false;
        for (RegionisedWorld world : this.getRegionisedWorlds()) {
            anySucceeded = world.remove(region) || anySucceeded;
        }
        anySucceeded = OrbisRegistries.REGIONS.unregister(region.key()).isPresent() || anySucceeded;
        File regionsFolder = this.dataFolder().resolve("regions").toFile();
        File regionFile = new File(String.valueOf(regionsFolder) + File.separator + region.name().replace(":", "-") + ".json");
        return anySucceeded && regionFile.delete();
    }

    @Override
    public SelectionManager selectionManager() {
        return this.selectionManager;
    }

    @Override
    public Set<RegionisedWorld> getRegionisedWorlds() {
        return this.worldSets.values().stream().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public RegionisedWorld getRegionisedWorld(Key worldId) {
        return this.worldSets.get(worldId);
    }

    public boolean isVisualising(UUID uuid) {
        return this.visualisingPlayers.contains(uuid);
    }

    public void setVisualising(UUID uuid, boolean visualising) {
        if (visualising) {
            this.visualisingPlayers.add(uuid);
        } else {
            this.visualisingPlayers.remove(uuid);
        }
    }

    public Set<UUID> getVisualisingPlayers() {
        return this.visualisingPlayers;
    }

    public boolean isTestEnvironment() {
        return false;
    }
}

