/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.area.EncompassingArea;
import org.empirewar.orbis.area.PolyhedralArea;
import org.empirewar.orbis.util.ExtraCodecs;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public sealed class PolygonArea
extends EncompassingArea
permits PolyhedralArea {
    public static final MapCodec<PolygonArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.VEC_3I.listOf().fieldOf("points").forGetter(c -> new LinkedList(c.points))).apply((Applicative)instance, PolygonArea::new));

    public PolygonArea() {
    }

    protected PolygonArea(List<Vector3ic> points) {
        super(points);
    }

    @Override
    public boolean contains(Vector3dc point) {
        return this.contains(point.x(), point.y(), point.z());
    }

    @Override
    public boolean contains(double x, double y, double z) {
        if (x < (double)this.min.x() || x > (double)this.max.x() || z < (double)this.min.z() || z > (double)this.max.z()) {
            return false;
        }
        double angle = 0.0;
        Vector3d blockPosition = new Vector3d(x, y, z);
        ArrayList pointsList = new ArrayList(this.points);
        for (int i = 0; i < this.points.size(); ++i) {
            Vector3ic point = (Vector3ic)pointsList.get(i);
            Vector3ic nextPoint = (Vector3ic)pointsList.get((i + 1) % pointsList.size());
            double xOffset = (double)point.x() - blockPosition.x();
            double zOffset = (double)point.z() - blockPosition.z();
            double nextXOffset = (double)nextPoint.x() - blockPosition.x();
            double nextZOffset = (double)nextPoint.z() - blockPosition.z();
            angle += this.angle(xOffset, zOffset, nextXOffset, nextZOffset);
        }
        return Math.abs(angle) >= Math.PI || angle == 0.0;
    }

    private double angle(double x1, double y1, double x2, double y2) {
        double dTheta;
        double theta1 = Math.atan2(y1, x1);
        double theta2 = Math.atan2(y2, x2);
        for (dTheta = theta2 - theta1; dTheta > Math.PI; dTheta -= Math.PI * 2) {
        }
        while (dTheta < -Math.PI) {
            dTheta += Math.PI * 2;
        }
        return dTheta;
    }

    @Override
    public AreaType<?> getType() {
        return AreaType.POLYGON;
    }

    @Override
    public Optional<Integer> getMaximumPoints() {
        return Optional.empty();
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }

    @Override
    public Set<Vector3ic> generateBoundaryPoints() {
        HashSet<Vector3ic> boundary = new HashSet<Vector3ic>();
        ArrayList<Vector3ic> pts = new ArrayList<Vector3ic>(this.points);
        if (pts.size() < 3) {
            return boundary;
        }
        List<Vector3ic> hull = this.convexHullXZ(pts);
        for (int i = 0; i < hull.size(); ++i) {
            Vector3ic a = hull.get(i);
            Vector3ic b = hull.get((i + 1) % hull.size());
            boundary.addAll(this.getLinePoints(a, b));
        }
        return boundary;
    }

    private List<Vector3ic> convexHullXZ(List<Vector3ic> pts) {
        ArrayList<Vector3ic> sorted = new ArrayList<Vector3ic>(pts);
        sorted.sort(Comparator.comparingInt(Vector3ic::x).thenComparingInt(Vector3ic::z));
        ArrayList<Vector3ic> lower = new ArrayList<Vector3ic>();
        for (Vector3ic p : sorted) {
            while (lower.size() >= 2 && this.cross((Vector3ic)lower.get(lower.size() - 2), (Vector3ic)lower.getLast(), p) <= 0L) {
                lower.removeLast();
            }
            lower.add(p);
        }
        ArrayList<Vector3ic> upper = new ArrayList<Vector3ic>();
        for (int i = sorted.size() - 1; i >= 0; --i) {
            Vector3ic p = (Vector3ic)sorted.get(i);
            while (upper.size() >= 2 && this.cross((Vector3ic)upper.get(upper.size() - 2), (Vector3ic)upper.getLast(), p) <= 0L) {
                upper.removeLast();
            }
            upper.add(p);
        }
        lower.removeLast();
        upper.removeLast();
        lower.addAll(upper);
        return lower;
    }

    private long cross(Vector3ic o, Vector3ic a, Vector3ic b) {
        return (long)(a.x() - o.x()) * (long)(b.z() - o.z()) - (long)(a.z() - o.z()) * (long)(b.x() - o.x());
    }

    private Set<Vector3i> getLinePoints(Vector3ic start, Vector3ic end) {
        int x1 = start.x();
        int y1 = start.y();
        int z1 = start.z();
        int x2 = end.x();
        int y2 = end.y();
        int z2 = end.z();
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int n = Math.max(Math.max(dx, dy), dz);
        HashSet<Vector3i> linePoints = new HashSet<Vector3i>(n);
        for (int i = 0; i <= n; ++i) {
            int x = x1 + i * (x2 - x1) / n;
            int y = y1 + i * (y2 - y1) / n;
            int z = z1 + i * (z2 - z1) / n;
            linePoints.add(new Vector3i(x, y, z));
        }
        return linePoints;
    }
}

