/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.neoforge.listener;

import java.util.Set;
import net.kyori.adventure.key.Keyed;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.neoforge.access.ServerPlayerDuck;
import org.empirewar.orbis.neoforge.api.event.RegionEnterEvent;
import org.empirewar.orbis.neoforge.api.event.RegionLeaveEvent;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.world.RegionisedWorld;

public final class MovementListener {
    private final Orbis orbis;

    public MovementListener(Orbis orbis) {
        this.orbis = orbis;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        RegionisedWorld world = this.orbis.getRegionisedWorld(((Keyed)player.level().dimension()).key());
        boolean canMove = world.query(RegionQuery.Position.builder().position(event.getTargetX(), event.getTargetY(), event.getTargetZ())).query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.getUUID())).result().orElse(true);
        if (!canMove) {
            event.setCanceled(true);
        } else if (!event.isCanceled()) {
            ((ServerPlayerDuck)player).orbis$setLastTickPosition(event.getTarget());
        }
    }

    @SubscribeEvent
    public void onMove(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Vec3 to = player.position();
        ServerPlayerDuck duck = (ServerPlayerDuck)player;
        Vec3 from = duck.orbis$getLastTickPosition() == null ? player.oldPosition() : duck.orbis$getLastTickPosition();
        RegionisedWorld world = this.orbis.getRegionisedWorld(((Keyed)player.level().dimension()).key());
        RegionQuery.FilterableRegionResult<RegionQuery.Position> toQuery = world.query(RegionQuery.Position.builder().position(to.x(), to.y(), to.z()));
        boolean canMove = toQuery.query(RegionQuery.Flag.builder(DefaultFlags.CAN_ENTER).player(player.getUUID())).result().orElse(true);
        if (!canMove) {
            player.teleportTo(from.x, from.y, from.z);
            return;
        }
        RegionQuery.FilterableRegionResult<RegionQuery.Position> fromQuery = world.query(RegionQuery.Position.builder().position(from.x(), from.y(), from.z()));
        Set toRegions = (Set)toQuery.result();
        Set fromRegions = (Set)fromQuery.result();
        for (Region possiblyEntered : toRegions) {
            if (fromRegions.contains(possiblyEntered)) continue;
            NeoForge.EVENT_BUS.post((Event)new RegionEnterEvent(player, player.level(), to, world, possiblyEntered));
        }
        for (Region possiblyLeft : fromRegions) {
            if (toRegions.contains(possiblyLeft)) continue;
            NeoForge.EVENT_BUS.post((Event)new RegionLeaveEvent(player, player.level(), to, world, possiblyLeft));
        }
    }
}

