/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.neoforge.listener;

import net.kyori.adventure.audience.Audience;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.neoforge.OrbisNeoForge;
import org.empirewar.orbis.neoforge.api.event.RegionEnterEvent;
import org.empirewar.orbis.neoforge.api.event.RegionLeaveEvent;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;

public final class RegionMessagesListener {
    private final OrbisNeoForge orbis;

    public RegionMessagesListener(OrbisNeoForge orbis) {
        this.orbis = orbis;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEnter(RegionEnterEvent event) {
        Player player = event.getEntity();
        Region region = event.getRegion();
        region.query(RegionQuery.Flag.builder(DefaultFlags.ENTRY_MESSAGE)).result().ifPresent(message -> ((Audience)player).sendMessage(this.orbis.miniMessage().deserialize(message)));
    }

    @SubscribeEvent
    public void onLeave(RegionLeaveEvent event) {
        Player player = event.getEntity();
        Region region = event.getRegion();
        region.query(RegionQuery.Flag.builder(DefaultFlags.EXIT_MESSAGE)).result().ifPresent(message -> ((Audience)player).sendMessage(this.orbis.miniMessage().deserialize(message)));
    }
}

