/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.registry.RegistryResolvable;
import org.empirewar.orbis.registry.ResolvableRegistry;
import org.empirewar.orbis.registry.StringOrbisRegistry;
import org.empirewar.orbis.registry.lifecycle.RegistryLifecycle;

public class ResolvableStringOrbisRegistry<T extends RegistryResolvable<String>>
extends StringOrbisRegistry<T>
implements ResolvableRegistry<T, String> {
    private final Map<String, List<PendingResolution<T>>> pending = new HashMap<String, List<PendingResolution<T>>>();

    public ResolvableStringOrbisRegistry(Key key) {
        super(key);
    }

    @Override
    public T register(String key, T entry) {
        super.register(key, entry);
        List<PendingResolution<T>> consumers = this.pending.remove(key);
        if (consumers != null) {
            OrbisAPI.get().logger().info("Resolving {} to {} consumers with {} lifecycle", new Object[]{key, consumers.size(), this.lifecycle.name()});
            for (PendingResolution<T> pr : consumers) {
                pr.consumer.accept(entry);
            }
        }
        return entry;
    }

    @Override
    public Optional<String> getKey(T entry) {
        return Optional.ofNullable((String)entry.key());
    }

    @Override
    public void resolve(String key, Consumer<T> consumer, RegistryLifecycle waitFor) {
        if (waitFor.hasExpired(this.lifecycle)) {
            throw new IllegalStateException("Cannot resolve with " + waitFor.name() + " lifecycle after " + this.lifecycle.name() + " phase");
        }
        RegistryResolvable value = this.get(key).orElse(null);
        if (value != null) {
            consumer.accept(value);
        } else {
            this.pending.computeIfAbsent(key, k -> new ArrayList()).add(new PendingResolution<T>(consumer, waitFor));
        }
    }

    @Override
    public void setLifecycle(RegistryLifecycle lifecycle) {
        super.setLifecycle(lifecycle);
        Iterator<Map.Entry<String, List<PendingResolution<T>>>> it = this.pending.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<PendingResolution<T>>> entry = it.next();
            List<PendingResolution<T>> list = entry.getValue();
            list.removeIf(pr -> {
                if (pr.lifecycle.hasExpired(lifecycle)) {
                    OrbisAPI.get().logger().error("Could not resolve '{}' before {} in registry '{}'", new Object[]{entry.getKey(), pr.lifecycle.name(), this.key().asString()});
                    return true;
                }
                return false;
            });
            if (!list.isEmpty()) continue;
            it.remove();
        }
    }

    private record PendingResolution<T>(Consumer<T> consumer, RegistryLifecycle lifecycle) {
    }
}

