/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.area;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.area.CuboidArea;
import org.empirewar.orbis.area.PolygonArea;
import org.empirewar.orbis.area.SphericalArea;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public abstract sealed class EncompassingArea
implements Area
permits CuboidArea, PolygonArea, SphericalArea {
    protected final Set<Vector3ic> points;
    protected final Set<Vector3ic> boundaryPoints;
    protected final Vector3i min = new Vector3i();
    protected final Vector3i max = new Vector3i();
    private final List<Runnable> updateListeners = new ArrayList<Runnable>(1);

    EncompassingArea() {
        int expected = this.getMaximumPoints().orElse(0);
        this.points = new LinkedHashSet<Vector3ic>(expected);
        this.boundaryPoints = new LinkedHashSet<Vector3ic>(expected * 4);
        this.calculateEncompassingArea();
    }

    EncompassingArea(List<Vector3ic> points) {
        this.points = new LinkedHashSet<Vector3ic>(points);
        this.boundaryPoints = new LinkedHashSet<Vector3ic>(points.size() * 4);
        this.calculateEncompassingArea();
    }

    public void addUpdateListener(Runnable listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(Runnable listener) {
        this.updateListeners.remove(listener);
    }

    protected void calculateEncompassingArea() {
        Vector3ic first = (Vector3ic)this.points.stream().findFirst().orElse(new Vector3i());
        int minX = first.x();
        int minY = first.y();
        int minZ = first.z();
        int maxX = minX;
        int maxY = minY;
        int maxZ = minZ;
        for (Vector3ic point : this.points) {
            minX = Math.min(point.x(), minX);
            minY = Math.min(point.y(), minY);
            minZ = Math.min(point.z(), minZ);
            maxX = Math.max(point.x(), maxX);
            maxY = Math.max(point.y(), maxY);
            maxZ = Math.max(point.z(), maxZ);
        }
        this.min.x = minX;
        this.min.y = minY;
        this.min.z = minZ;
        this.max.x = maxX;
        this.max.y = maxY;
        this.max.z = maxZ;
        this.boundaryPoints.clear();
        if (this.points.size() >= this.getMinimumPoints()) {
            this.boundaryPoints.addAll(this.generateBoundaryPoints());
        }
        List.copyOf(this.updateListeners).forEach(Runnable::run);
    }

    @Override
    public void clearPoints() {
        this.points.clear();
        this.calculateEncompassingArea();
    }

    @Override
    public boolean addPoint(Vector3ic point) {
        Optional<Integer> expectedPoints = this.getMaximumPoints();
        if (expectedPoints.isPresent() && this.points.size() + 1 > expectedPoints.get()) {
            return false;
        }
        if (this.points.add(point)) {
            this.calculateEncompassingArea();
            return true;
        }
        return false;
    }

    @Override
    public boolean removePoint(Vector3ic point) {
        if (this.points.remove(point)) {
            this.calculateEncompassingArea();
            return true;
        }
        return false;
    }

    @Override
    public Vector3ic getMin() {
        return this.min;
    }

    @Override
    public Vector3ic getMax() {
        return this.max;
    }

    @Override
    public Set<Vector3ic> points() {
        return Set.copyOf(this.points);
    }

    @Override
    public Set<Vector3ic> getBoundaryPoints() {
        return this.boundaryPoints;
    }

    protected abstract Set<Vector3ic> generateBoundaryPoints();

    public abstract Optional<Integer> getMaximumPoints();

    public abstract int getMinimumPoints();

    @Override
    @NotNull
    public Iterator<Vector3ic> iterator() {
        HashSet<Vector3i> blocks = new HashSet<Vector3i>();
        for (int x = this.min.x; x <= this.max.x; ++x) {
            for (int y = this.min.y; y <= this.max.y; ++y) {
                for (int z = this.min.z; z <= this.max.z; ++z) {
                    if (!this.contains(x, y, z)) continue;
                    blocks.add(new Vector3i(x, y, z));
                }
            }
        }
        return blocks.iterator();
    }
}

