/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.leangen.geantyref.TypeToken;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.flag.value.FlagValue;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserParameters;
import org.incendo.cloud.parser.ParserRegistry;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionProvider;

public record FlagValueParser<C>(CommandManager<C> manager) implements ArgumentParser.FutureArgumentParser<C, FlagValue<?>>,
SuggestionProvider<C>
{
    private static final Pattern FLAG_PATTERN = Pattern.compile("(-[A-Za-z_\\-0-9])|(--[A-Za-z_\\-0-9]*)");

    public @NonNull CompletableFuture<@NonNull ArgumentParseResult<FlagValue<?>>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = (String)this.parseGreedy(commandInput).parsedValue().orElseThrow();
        RegistryRegionFlag flag = (RegistryRegionFlag)commandContext.get("flag");
        try {
            JsonElement element;
            try {
                element = JsonParser.parseString((String)input);
                if (element == null || element.isJsonNull()) {
                    element = new JsonPrimitive(input);
                }
            }
            catch (Exception e) {
                element = new JsonPrimitive(input);
            }
            Codec codec = flag.typeCodec();
            DataResult result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.isError()) {
                return ArgumentParseResult.failureFuture((Throwable)((Object)new FlagValueParserException(input, ((DataResult.Error)result.error().orElseThrow()).message(), commandContext)));
            }
            return ArgumentParseResult.successFuture(new FlagValue(result.result().orElseThrow()));
        }
        catch (Exception e) {
            return ArgumentParseResult.failureFuture((Throwable)((Object)new FlagValueParserException(input, e.getMessage(), commandContext)));
        }
    }

    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> context, @NonNull CommandInput input) {
        Class valueType;
        RegistryRegionFlag flag = (RegistryRegionFlag)context.get("flag");
        ParserRegistry parserRegistry = this.manager.parserRegistry();
        Optional parser = this.findParserForType(parserRegistry, valueType = flag.defaultValueType());
        if (parser.isPresent()) {
            return parser.get().suggestionProvider().suggestionsFuture(context, input);
        }
        return CompletableFuture.completedFuture(List.of());
    }

    private Optional<? extends ArgumentParser<C, ?>> findParserForType(ParserRegistry<C> registry, Class<?> type) {
        Optional exact = registry.createParser(TypeToken.get(type), ParserParameters.empty());
        if (exact.isPresent()) {
            return exact;
        }
        for (Class<?> superClass = type.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            Optional superParser = registry.createParser(TypeToken.get(superClass), ParserParameters.empty());
            if (!superParser.isPresent()) continue;
            return superParser;
        }
        for (Class<?> iface : this.getAllInterfaces(type)) {
            Optional ifaceParser = registry.createParser(TypeToken.get(iface), ParserParameters.empty());
            if (!ifaceParser.isPresent()) continue;
            return ifaceParser;
        }
        return Optional.empty();
    }

    private Set<Class<?>> getAllInterfaces(Class<?> type) {
        LinkedHashSet interfaces = new LinkedHashSet();
        this.collectInterfaces(type, interfaces);
        return interfaces;
    }

    private void collectInterfaces(Class<?> type, Set<Class<?>> out) {
        for (Class<?> iface : type.getInterfaces()) {
            if (!out.add(iface)) continue;
            this.collectInterfaces(iface, out);
        }
        if (type.getSuperclass() != null) {
            this.collectInterfaces(type.getSuperclass(), out);
        }
    }

    private @NonNull ArgumentParseResult<String> parseGreedy(@NonNull CommandInput commandInput) {
        String string;
        int size = commandInput.remainingTokens();
        StringJoiner stringJoiner = new StringJoiner(" ");
        for (int i = 0; i < size && !(string = commandInput.peekString()).isEmpty() && !FLAG_PATTERN.matcher(string).matches(); ++i) {
            stringJoiner.add(commandInput.readStringSkipWhitespace(false));
        }
        return ArgumentParseResult.success((Object)stringJoiner.toString());
    }

    public static final class FlagValueParserException
    extends ParserException {
        public FlagValueParserException(@NonNull String input, String error, @NonNull CommandContext<?> context) {
            super(FlagValueParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_VALUE_INVALID, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input), CaptionVariable.of((String)"error", (String)error)});
        }
    }
}

