/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.flag;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.flag.MutableRegionFlag;
import org.empirewar.orbis.flag.RegionFlagType;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.member.FlagMemberGroup;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.util.EnumCodec;

public final class GroupedMutableRegionFlag<T>
extends MutableRegionFlag<T> {
    public static final MapCodec<GroupedMutableRegionFlag<?>> CODEC = OrbisRegistries.FLAGS.getCodec().dispatchMap(mu -> (RegistryRegionFlag)OrbisRegistries.FLAGS.get(mu.key()).orElseThrow(), r -> r.asGrouped().getCodec((RegistryRegionFlag<?>)r));
    private final Set<FlagMemberGroup> groups = new HashSet<FlagMemberGroup>();

    GroupedMutableRegionFlag(Key key, Supplier<T> defaultValue, Codec<T> codec) {
        super(key, defaultValue, codec);
    }

    public Set<FlagMemberGroup> groups() {
        return Set.copyOf(this.groups);
    }

    public void addGroup(FlagMemberGroup group) {
        this.groups.add(group);
    }

    public void removeGroup(FlagMemberGroup group) {
        this.groups.remove((Object)group);
    }

    @Override
    public RegionFlagType<?> getType() {
        return RegionFlagType.GROUPED_MUTABLE;
    }

    @Override
    public MapCodec<? extends GroupedMutableRegionFlag<T>> getCodec(RegistryRegionFlag<?> registry) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)this.codec.fieldOf("value").forGetter(MutableRegionFlag::getValue), (App)new EnumCodec<FlagMemberGroup>(FlagMemberGroup.class).listOf().fieldOf("groups").forGetter(gmu -> gmu.groups().stream().toList())).apply((Applicative)instance, (value, groups) -> {
            GroupedMutableRegionFlag<Object> mutable = registry.asGrouped();
            mutable.setValue(value);
            groups.forEach(mutable::addGroup);
            return mutable;
        }));
    }
}

