/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.flag;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.flag.GroupedMutableRegionFlag;
import org.empirewar.orbis.flag.MutableRegionFlag;
import org.empirewar.orbis.flag.RegionFlag;
import org.empirewar.orbis.flag.RegionFlagBuilder;
import org.jetbrains.annotations.Nullable;

public final class RegistryRegionFlag<T>
extends RegionFlag<T> {
    private final Supplier<T> defaultValueSupplier;
    private final Class<T> defaultValueType;
    @Nullable
    private final String description;

    RegistryRegionFlag(Key key, @Nullable String description, Supplier<T> defaultValue, Codec<T> codec) {
        super(key, codec);
        this.defaultValueSupplier = defaultValue;
        this.defaultValueType = defaultValue.get().getClass();
        this.description = description;
    }

    public Class<T> defaultValueType() {
        return this.defaultValueType;
    }

    public MutableRegionFlag<T> asMutable() {
        return new MutableRegionFlag<T>(this.key, this.defaultValueSupplier, this.codec);
    }

    public GroupedMutableRegionFlag<T> asGrouped() {
        return new GroupedMutableRegionFlag<T>(this.key, this.defaultValueSupplier, this.codec);
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public static <T> Builder<T> builder() {
        return new RegionFlagBuilder();
    }

    public static sealed interface Builder<T>
    permits RegionFlagBuilder {
        public Builder<T> key(Key var1);

        public Builder<T> description(@Nullable String var1);

        public Builder<T> defaultValue(Supplier<T> var1);

        public Builder<T> codec(Codec<T> var1);

        public RegistryRegionFlag<T> build();
    }
}

