/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.member;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.UUID;
import org.empirewar.orbis.member.Member;
import org.empirewar.orbis.member.MemberType;
import org.empirewar.orbis.util.ExtraCodecs;

public final class PlayerMember
extends Member {
    public static MapCodec<PlayerMember> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.STRING_UUID.fieldOf("player_id").forGetter(PlayerMember::playerId)).apply((Applicative)instance, PlayerMember::new));
    private final UUID playerId;

    public PlayerMember(UUID playerId) {
        this.playerId = playerId;
    }

    public UUID playerId() {
        return this.playerId;
    }

    @Override
    public boolean checkMember(UUID member) {
        return member.equals(this.playerId);
    }

    @Override
    public MemberType<?> getType() {
        return MemberType.PLAYER;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlayerMember)) {
            return false;
        }
        PlayerMember that = (PlayerMember)object;
        return Objects.equals(this.playerId, that.playerId);
    }

    public int hashCode() {
        return Objects.hashCode(this.playerId);
    }
}

