/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.neoforge.listener;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.modded.util.FlagActions;

public final class InteractEntityListener {
    public InteractEntityListener(Orbis orbis) {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingAttack(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!FlagActions.shouldPreventEntityAction((Entity)player, DefaultFlags.INVULNERABILITY)) {
                event.setCanceled(true);
                return;
            }
            Entity direct = event.getSource().getDirectEntity();
            if (!(direct instanceof ServerPlayer) && FlagActions.shouldPreventEntityAction((Entity)player, DefaultFlags.CAN_TAKE_MOB_DAMAGE_SOURCES)) {
                event.setCanceled(true);
            }
        }
    }
}

